/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.EnumTypeObject;
import org.opendaylight.yangtools.binding.data.codec.impl.SchemaUnawareCodec;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EnumerationCodec
extends SchemaUnawareCodec {
    private static final Logger LOG = LoggerFactory.getLogger(EnumerationCodec.class);
    private static final Cache<Class<? extends EnumTypeObject>, @NonNull EnumerationCodec> CACHE = CacheBuilder.newBuilder().weakKeys().softValues().build();
    private final ImmutableBiMap<String, Enum<?>> nameToEnum;
    private final Class<? extends Enum<?>> enumClass;

    private EnumerationCodec(Class<? extends Enum<?>> enumClass, Map<String, Enum<?>> nameToEnum) {
        this.enumClass = Objects.requireNonNull(enumClass);
        this.nameToEnum = ImmutableBiMap.copyOf(nameToEnum);
    }

    static @NonNull EnumerationCodec of(Class<?> returnType, EnumTypeDefinition def) throws ExecutionException {
        return (EnumerationCodec)CACHE.get(returnType.asSubclass(EnumTypeObject.class), () -> {
            Class<Enum<?>> enumType = EnumerationCodec.castType(returnType);
            ImmutableMap mapping = Maps.uniqueIndex(Arrays.asList(enumType.getEnumConstants()), value -> {
                Preconditions.checkArgument((boolean)(value instanceof EnumTypeObject), (String)"Enumeration constant %s.%s is not implementing EnumTypeObject", (Object)enumType.getName(), (Object)value);
                return ((EnumTypeObject)value).getName();
            });
            Set assignedNames = def.getValues().stream().map(EnumTypeDefinition.EnumPair::getName).collect(Collectors.toSet());
            for (String name : assignedNames) {
                if (mapping.containsKey(name)) continue;
                LOG.warn("Enumeration {} does not contain assigned name '{}' from {}", new Object[]{enumType, name, def});
            }
            for (String name : mapping.keySet()) {
                if (assignedNames.contains(name)) continue;
                LOG.warn("Enumeration {} contains assigned name '{}' not covered by {}", new Object[]{enumType, name, def});
            }
            return new EnumerationCodec((Class<? extends Enum<?>>)enumType, (Map<String, Enum<?>>)mapping);
        });
    }

    private static Class<? extends Enum<?>> castType(Class<?> returnType) {
        Preconditions.checkArgument((boolean)Enum.class.isAssignableFrom(returnType));
        return returnType.asSubclass(Enum.class);
    }

    @Override
    protected Enum<?> deserializeImpl(Object input) {
        Preconditions.checkArgument((boolean)(input instanceof String), (String)"Input %s is not a String", (Object)input);
        Enum value = (Enum)this.nameToEnum.get(input);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Invalid enumeration value %s. Valid values are %s", (Object)input, (Object)this.nameToEnum.keySet());
        return value;
    }

    @Override
    protected String serializeImpl(Object input) {
        Preconditions.checkArgument((boolean)this.enumClass.isInstance(input), (String)"Input %s is not a instance of %s", (Object)input, this.enumClass);
        return (String)Verify.verifyNotNull((Object)((String)this.nameToEnum.inverse().get(input)));
    }
}

