/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.data.codec.impl.LazyBindingMapIterState;
import org.opendaylight.yangtools.binding.data.codec.impl.LazyBindingMapLookupState;
import org.opendaylight.yangtools.binding.data.codec.impl.MapCodecContext;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LazyBindingMap<K extends Key<V>, V extends EntryObject<V, K>>
extends AbstractMap<K, V>
implements Immutable {
    private static final Logger LOG = LoggerFactory.getLogger(LazyBindingMap.class);
    private static final String LAZY_CUTOFF_PROPERTY = "org.opendaylight.mdsal.binding.dom.codec.impl.LazyBindingMap.max-eager-elements";
    private static final int DEFAULT_LAZY_CUTOFF = 1;
    @VisibleForTesting
    static final int LAZY_CUTOFF;
    private static final VarHandle STATE;
    private final  @NonNull MapCodecContext.Unordered<K, V> codec;
    private final @NonNull MapNode mapNode;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile State<K, V> state;

    private LazyBindingMap(MapCodecContext.Unordered<K, V> codec, MapNode mapNode) {
        this.codec = Objects.requireNonNull(codec);
        this.mapNode = Objects.requireNonNull(mapNode);
    }

    static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(MapCodecContext.Unordered<K, V> codec, MapNode mapNode, int size) {
        if (size == 1) {
            EntryObject entry = (EntryObject)codec.createBindingProxy((DataContainerNode)mapNode.body().iterator().next());
            return Map.of(entry.key(), entry);
        }
        return size > LAZY_CUTOFF ? new LazyBindingMap<K, V>(codec, mapNode) : LazyBindingMap.eagerMap(codec, mapNode, size);
    }

    private static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> eagerMap(MapCodecContext.Unordered<K, V> codec, MapNode mapNode, int size) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)size);
        for (MapEntryNode node : mapNode.body()) {
            EntryObject entry = (EntryObject)codec.createBindingProxy((DataContainerNode)node);
            builder.put((Object)entry.key(), (Object)entry);
        }
        return builder.build();
    }

    @Override
    public int size() {
        return this.mapNode.size();
    }

    @Override
    public V remove(Object key) {
        throw LazyBindingMap.uoe();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw LazyBindingMap.uoe();
    }

    @Override
    public void clear() {
        throw LazyBindingMap.uoe();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.lookupState().containsKey(Objects.requireNonNull(key));
    }

    @Override
    public boolean containsValue(Object value) {
        EntryObject cast = (EntryObject)this.codec.getBindingClass().cast(Objects.requireNonNull(value));
        V found = this.get(cast.key());
        return found != null && cast.equals(found);
    }

    @Override
    public V get(Object key) {
        return this.lookupState().get(Objects.requireNonNull(key));
    }

    @Override
    public Set<K> keySet() {
        return this.iterState().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.iterState().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.iterState().entrySet();
    }

    @NonNull V createValue(MapEntryNode node) {
        return (V)((EntryObject)this.codec.createBindingProxy((DataContainerNode)node));
    }

    Optional<V> lookupValue(@NonNull Object key) {
        YangInstanceIdentifier.NodeIdentifierWithPredicates childId = this.codec.serialize((Key)key);
        return this.mapNode.findChildByArg((YangInstanceIdentifier.PathArgument)childId).map(this.codec::createBindingProxy);
    }

    @NonNull MapNode mapNode() {
        return this.mapNode;
    }

    private @NonNull State<K, V> lookupState() {
        State<K, V> local = STATE.getAcquire(this);
        return local != null ? local : this.loadLookup();
    }

    private @NonNull State<K, V> iterState() {
        State<K, V> local = STATE.getAcquire(this);
        return local != null ? local : this.loadIter();
    }

    private @NonNull State<K, V> loadLookup() {
        LazyBindingMapLookupState ret = new LazyBindingMapLookupState(this);
        Object witness = STATE.compareAndExchangeRelease(this, null, ret);
        return witness == null ? ret : (State)witness;
    }

    private @NonNull State<K, V> loadIter() {
        LazyBindingMapIterState ret = new LazyBindingMapIterState(this);
        Object witness = STATE.compareAndExchangeRelease(this, null, ret);
        return witness == null ? ret : (State)witness;
    }

    private static UnsupportedOperationException uoe() {
        return new UnsupportedOperationException("Modification is not supported");
    }

    static {
        try {
            STATE = MethodHandles.lookup().findVarHandle(LazyBindingMap.class, "state", State.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
        int value = Integer.getInteger(LAZY_CUTOFF_PROPERTY, 1);
        if (value < 0) {
            LOG.info("Lazy population of maps disabled");
            LAZY_CUTOFF = Integer.MAX_VALUE;
        } else {
            LOG.info("Using lazy population for maps larger than {} element(s)", (Object)value);
            LAZY_CUTOFF = value;
        }
    }

    static abstract class State<K extends Key<V>, V extends EntryObject<V, K>> {
        State() {
        }

        abstract boolean containsKey(@NonNull Object var1);

        abstract V get(@NonNull Object var1);

        abstract @NonNull Set<K> keySet();

        abstract @NonNull Collection<V> values();

        abstract @NonNull Set<Map.Entry<K, V>> entrySet();
    }
}

