/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.NodeStep;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextFactory;
import org.opendaylight.yangtools.binding.data.codec.impl.DataObjectCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.LazyBindingList;
import org.opendaylight.yangtools.binding.data.codec.impl.ListCodecPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.MapCodecContext;
import org.opendaylight.yangtools.binding.runtime.api.ListRuntimeType;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;

sealed class ListCodecContext<D extends DataObject>
extends DataObjectCodecContext<D, ListRuntimeType>
permits MapCodecContext {
    ListCodecContext(Class<D> cls, ListRuntimeType list, CodecContextFactory factory) {
        this(new ListCodecPrototype((DataObjectStep<?>)new NodeStep(cls), list, factory));
    }

    ListCodecContext(ListCodecPrototype prototype) {
        super(prototype);
    }

    ListCodecContext(ListCodecPrototype prototype, Method keyMethod) {
        super(prototype, keyMethod);
    }

    public D deserialize(NormalizedNode node) {
        NormalizedNode nonnull = Objects.requireNonNull(node);
        if (nonnull instanceof MapEntryNode) {
            MapEntryNode mapEntry = (MapEntryNode)nonnull;
            return this.createBindingProxy((DataContainerNode)mapEntry);
        }
        if (nonnull instanceof UnkeyedListEntryNode) {
            UnkeyedListEntryNode unkeyedEntry = (UnkeyedListEntryNode)nonnull;
            return this.createBindingProxy((DataContainerNode)unkeyedEntry);
        }
        throw new IllegalArgumentException("Expecting either a MapEntryNode or an UnkeyedListEntryNode, not " + node.contract().getSimpleName());
    }

    @Override
    Object deserializeObject(NormalizedNode node) {
        if (node instanceof MapNode) {
            MapNode map = (MapNode)node;
            return this.fromMap(map);
        }
        if (node instanceof MapEntryNode) {
            MapEntryNode mapEntry = (MapEntryNode)node;
            return this.createBindingProxy((DataContainerNode)mapEntry);
        }
        if (node instanceof UnkeyedListNode) {
            UnkeyedListNode list = (UnkeyedListNode)node;
            return this.fromUnkeyedList(list);
        }
        if (node instanceof UnkeyedListEntryNode) {
            UnkeyedListEntryNode listEntry = (UnkeyedListEntryNode)node;
            return this.createBindingProxy((DataContainerNode)listEntry);
        }
        throw new IllegalStateException("Unsupported data type " + node.contract().getSimpleName());
    }

    @NonNull Object fromMap(MapNode map, int size) {
        return LazyBindingList.of(this, size, map.body());
    }

    private Object fromMap(MapNode map) {
        int size = map.size();
        return size == 0 ? null : this.fromMap(map, size);
    }

    private List<D> fromUnkeyedList(UnkeyedListNode node) {
        int size = node.size();
        return size == 0 ? null : LazyBindingList.of(this, size, node.body());
    }
}

