/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.data.codec.impl.AbstractValueCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.BitsCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.EncapsulatedValueCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.EnumerationCodec;
import org.opendaylight.yangtools.binding.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;

abstract class SchemaUnawareCodec
extends AbstractValueCodec<Object, Object> {
    SchemaUnawareCodec() {
    }

    static @Nullable SchemaUnawareCodec of(Class<?> typeClz, TypeDefinition<?> def) {
        return BindingReflections.isBindingClass(typeClz) ? SchemaUnawareCodec.getCachedSchemaUnawareCodec(typeClz, def) : null;
    }

    private static @NonNull SchemaUnawareCodec getCachedSchemaUnawareCodec(Class<?> typeClz, TypeDefinition<?> def) {
        TypeDefinition base;
        TypeDefinition rootType = Objects.requireNonNull(def);
        while ((base = rootType.getBaseType()) != null) {
            rootType = base;
        }
        try {
            if (rootType instanceof EnumTypeDefinition) {
                EnumTypeDefinition enumType = (EnumTypeDefinition)rootType;
                return EnumerationCodec.of(typeClz, enumType);
            }
            if (rootType instanceof BitsTypeDefinition) {
                BitsTypeDefinition bitsType = (BitsTypeDefinition)rootType;
                return BitsCodec.of(typeClz, bitsType);
            }
            return EncapsulatedValueCodec.of(typeClz);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }
}

