/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.binding.contract.Naming;
import org.opendaylight.yangtools.binding.data.codec.impl.BindingCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.UnionValueOptionContext;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueCodec;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeGeneratedUnion;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;

final class UnionTypeCodec
implements ValueCodec<Object, Object> {
    private final ImmutableSet<UnionValueOptionContext> typeCodecs;
    private final Class<?> unionClass;

    private UnionTypeCodec(Class<?> unionClass, List<UnionValueOptionContext> typeCodecs) {
        this.unionClass = Objects.requireNonNull(unionClass);
        this.typeCodecs = ImmutableSet.copyOf(typeCodecs);
    }

    static UnionTypeCodec of(Class<?> unionCls, UnionTypeDefinition unionType, BindingCodecContext codecContext) throws Exception {
        List<String> unionProperties = UnionTypeCodec.extractUnionProperties(codecContext.getRuntimeContext().getTypeWithSchema(unionCls).javaType());
        List unionTypes = unionType.getTypes();
        Verify.verify((unionTypes.size() == unionProperties.size() ? 1 : 0) != 0, (String)"Mismatched union types %s and properties %s", (Object)unionTypes, unionProperties);
        ArrayList<UnionValueOptionContext> values = new ArrayList<UnionValueOptionContext>(unionTypes.size());
        Iterator<String> it = unionProperties.iterator();
        for (TypeDefinition subtype : unionTypes) {
            String getterName = "get" + Naming.toFirstUpper((String)it.next());
            Method valueGetter = unionCls.getMethod(getterName, new Class[0]);
            Class<?> valueType = valueGetter.getReturnType();
            ValueCodec<Object, Object> codec = codecContext.getCodec(valueType, subtype);
            values.add(new UnionValueOptionContext(unionCls, valueType, valueGetter, codec));
        }
        return new UnionTypeCodec(unionCls, values);
    }

    private static List<String> extractUnionProperties(Type type) {
        Verify.verify((boolean)(type instanceof GeneratedTransferObject), (String)"Unexpected runtime type %s", (Object)type);
        GeneratedTransferObject gto = (GeneratedTransferObject)type;
        while (!(gto instanceof RuntimeGeneratedUnion)) {
            gto = (GeneratedTransferObject)Verify.verifyNotNull((Object)gto.getSuperType(), (String)"Cannot find union type information for %s", (Object[])new Object[]{type});
        }
        return ((RuntimeGeneratedUnion)gto).typePropertyNames();
    }

    @Override
    public Object deserialize(Object input) {
        for (UnionValueOptionContext member : this.typeCodecs) {
            Object ret = member.deserializeUnion(input);
            if (ret == null) continue;
            return ret;
        }
        throw new IllegalArgumentException(String.format("Failed to construct instance of %s for input %s", this.unionClass, input));
    }

    @Override
    public Object serialize(Object input) {
        for (UnionValueOptionContext valCtx : this.typeCodecs) {
            Object domValue = valCtx.serialize(input);
            if (domValue == null) continue;
            return domValue;
        }
        throw new IllegalStateException("No codec matched value " + String.valueOf(input));
    }
}

