/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStorage;
import org.opendaylight.yangtools.yang.parser.spi.meta.ParserNamespace;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceAccess;

final class BehaviourNamespaceAccess<K, V>
extends NamespaceAccess<K, V> {
    private final @NonNull NamespaceBehaviour<K, V> behaviour;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull NamespaceStorage.GlobalStorage globalStorage;
    private Multimap<K, NamespaceAccess.KeyedValueAddedListener<K, V>> keyListeners;
    private List<NamespaceAccess.PredicateValueAddedListener<K, V>> predicateListeners;

    BehaviourNamespaceAccess(NamespaceStorage.GlobalStorage globalStorage, NamespaceBehaviour<K, V> behaviour) {
        this.globalStorage = Objects.requireNonNull(globalStorage);
        this.behaviour = Objects.requireNonNull(behaviour);
    }

    @Override
    ParserNamespace<K, V> namespace() {
        return this.behaviour.namespace();
    }

    @Override
    V valueFrom(NamespaceStorage storage, K key) {
        return (V)this.behaviour.getFrom(this.globalStorage, storage, key);
    }

    @Override
    void valueTo(NamespaceStorage storage, K key, V value) {
        Collection listeners;
        this.behaviour.addTo(this.globalStorage, storage, key, value);
        if (this.keyListeners != null && !(listeners = this.keyListeners.get(key)).isEmpty()) {
            ArrayList<NamespaceAccess.KeyedValueAddedListener> toNotify = new ArrayList<NamespaceAccess.KeyedValueAddedListener>();
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                NamespaceAccess.KeyedValueAddedListener listener = (NamespaceAccess.KeyedValueAddedListener)it.next();
                if (!listener.isRequestedValue(this, storage, key, value)) continue;
                it.remove();
                toNotify.add(listener);
            }
            for (NamespaceAccess.KeyedValueAddedListener listener : toNotify) {
                listener.onValueAdded(key, value);
            }
            if (this.keyListeners.isEmpty()) {
                this.keyListeners = null;
            }
        }
        if (this.predicateListeners != null) {
            Iterator<NamespaceAccess.PredicateValueAddedListener<K, V>> it = this.predicateListeners.iterator();
            while (it.hasNext()) {
                if (!it.next().onValueAdded(key, value)) continue;
                it.remove();
            }
            if (this.predicateListeners != null && this.predicateListeners.isEmpty()) {
                this.predicateListeners = null;
            }
        }
    }

    @Override
    Map<K, V> allFrom(NamespaceStorage storage) {
        return this.behaviour.getAllFrom(this.globalStorage, storage);
    }

    @Override
    Map.Entry<K, V> entryFrom(NamespaceStorage storage, NamespaceKeyCriterion<K> criterion) {
        return this.behaviour.getFrom(this.globalStorage, storage, criterion);
    }

    @Override
    void addListener(K key, NamespaceAccess.KeyedValueAddedListener<K, V> listener) {
        K k = Objects.requireNonNull(key);
        NamespaceAccess.KeyedValueAddedListener<K, V> l = Objects.requireNonNull(listener);
        if (this.keyListeners == null) {
            this.keyListeners = Multimaps.newMultimap(new HashMap(), ArrayDeque::new);
        }
        this.keyListeners.put(k, l);
    }

    @Override
    void addListener(NamespaceAccess.PredicateValueAddedListener<K, V> listener) {
        if (this.predicateListeners == null) {
            this.predicateListeners = new ArrayList<NamespaceAccess.PredicateValueAddedListener<K, V>>();
        }
        this.predicateListeners.add(listener);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("behaviour", this.behaviour).toString();
    }
}

