/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EffectiveInstances<E extends EffectiveStatement<?, ?>>
implements Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(EffectiveInstances.class);
    private final Map<EffectiveStatementState, E> copies = new HashMap<EffectiveStatementState, E>(4);
    private final @NonNull E local;

    EffectiveInstances(E local) {
        this.local = (EffectiveStatement)Objects.requireNonNull(local);
    }

    static <E extends EffectiveStatement<?, ?>> @NonNull E local(Object obj) {
        return (E)(obj instanceof EffectiveInstances ? ((EffectiveInstances)obj).local : Objects.requireNonNull((EffectiveStatement)obj));
    }

    @NonNull E attachCopy(@NonNull EffectiveStatementState key, @NonNull E copy) {
        List copyStmts;
        EffectiveStatement prev = this.copies.putIfAbsent(Objects.requireNonNull(key), (EffectiveStatement)Objects.requireNonNull(copy));
        if (prev == null) {
            return copy;
        }
        List prevStmts = prev.effectiveSubstatements();
        if (prevStmts != (copyStmts = copy.effectiveSubstatements())) {
            if (prevStmts.size() != copyStmts.size()) {
                LOG.trace("Key {} substatement count mismatch", (Object)key);
                return copy;
            }
            Iterator prevIt = prevStmts.iterator();
            Iterator copyIt = copyStmts.iterator();
            while (prevIt.hasNext()) {
                if (prevIt.next() == copyIt.next()) continue;
                LOG.trace("Key {} substatement mismatch", (Object)key);
                return copy;
            }
        }
        LOG.trace("Key {} substatement reused", (Object)key);
        return (E)prev;
    }
}

