/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.databroker.CommitStatsMXBeanImpl;
import org.opendaylight.controller.cluster.databroker.ConcurrentDOMDataBroker;
import org.opendaylight.controller.md.sal.common.util.jmx.ThreadExecutorStatsMXBeanImpl;
import org.opendaylight.yangtools.util.DurationStatisticsTracker;
import org.opendaylight.yangtools.util.concurrent.SpecialExecutors;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DataBrokerCommitExecutor.class}, configurationPid={"org.opendaylight.controller.cluster.datastore.broker"})
@Designate(ocd=Config.class)
public final class DataBrokerCommitExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DataBrokerCommitExecutor.class);
    private final DurationStatisticsTracker commitStatsTracker = DurationStatisticsTracker.createConcurrent();
    private final ThreadExecutorStatsMXBeanImpl threadStats;
    private final CommitStatsMXBeanImpl commitStats;
    private final ExecutorService executorService;

    @Activate
    public DataBrokerCommitExecutor(Config config) {
        this.executorService = SpecialExecutors.newBlockingBoundedCachedThreadPool((int)config.callbackPoolSize(), (int)config.callbackQueueSize(), (String)"CommitFutures", ConcurrentDOMDataBroker.class);
        this.threadStats = ThreadExecutorStatsMXBeanImpl.create((Executor)this.executorService, (String)"CommitFutureExecutorStats", (String)"DOMDataBroker");
        this.commitStats = new CommitStatsMXBeanImpl(this.commitStatsTracker, "DOMDataBroker");
        this.commitStats.register();
        LOG.info("DOM Data Broker commit exector started");
    }

    @Deactivate
    void deactivate() {
        LOG.info("DOM Data Broker commit exector stopping");
        this.commitStats.unregister();
        this.threadStats.unregister();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOG.warn("Future executor failed to finish in time, giving up", (Throwable)e);
        }
        LOG.info("DOM Data Broker commit exector stopped");
    }

    Executor executor() {
        return this.executorService;
    }

    DurationStatisticsTracker commitStatsTracker() {
        return this.commitStatsTracker;
    }

    @ObjectClassDefinition
    public static @interface Config {
        @AttributeDefinition(name="max-data-broker-future-callback-queue-size")
        public int callbackQueueSize() default 1000;

        @AttributeDefinition(name="max-data-broker-future-callback-pool-size")
        public int callbackPoolSize() default 20;
    }
}

