/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import akka.dispatch.ExecutionContexts;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableBiMap;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractShardBackendResolver;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.controller.cluster.datastore.shardmanager.RegisterForShardAvailabilityChanges;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

final class ModuleShardBackendResolver
extends AbstractShardBackendResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleShardBackendResolver.class);
    private final ConcurrentMap<Long, AbstractShardBackendResolver.ShardState> backends = new ConcurrentHashMap<Long, AbstractShardBackendResolver.ShardState>();
    private final Future<Registration> shardAvailabilityChangesRegFuture;
    private @GuardedBy(value={"this"}) long nextShard = 1L;
    private volatile ImmutableBiMap<String, Long> shards = ImmutableBiMap.of((Object)"default", (Object)0L);

    ModuleShardBackendResolver(ClientIdentifier clientId, ActorUtils actorUtils) {
        super(clientId, actorUtils);
        this.shardAvailabilityChangesRegFuture = Patterns.ask((ActorRef)actorUtils.getShardManager(), (Object)new RegisterForShardAvailabilityChanges(this::onShardAvailabilityChange), (Timeout)Timeout.apply((long)60L, (TimeUnit)TimeUnit.MINUTES)).map(reply -> (Registration)reply, (ExecutionContext)ExecutionContexts.global());
        this.shardAvailabilityChangesRegFuture.onComplete((Function1)new OnComplete<Registration>(this){

            public void onComplete(Throwable failure, Registration reply) {
                if (failure != null) {
                    LOG.error("RegisterForShardAvailabilityChanges failed", failure);
                }
            }
        }, (ExecutionContext)ExecutionContexts.global());
    }

    private void onShardAvailabilityChange(String shardName) {
        LOG.debug("onShardAvailabilityChange for {}", (Object)shardName);
        Long cookie = (Long)this.shards.get((Object)shardName);
        if (cookie == null) {
            LOG.debug("No shard cookie found for {}", (Object)shardName);
            return;
        }
        this.notifyStaleBackendInfoCallbacks(cookie);
    }

    Long resolveShardForPath(YangInstanceIdentifier path) {
        return this.resolveCookie(this.actorUtils().getShardStrategyFactory().getStrategy(path).findShard(path));
    }

    Stream<Long> resolveAllShards() {
        return this.actorUtils().getConfiguration().getAllShardNames().stream().sorted().map(this::resolveCookie);
    }

    private @NonNull Long resolveCookie(String shardName) {
        Long cookie = (Long)this.shards.get((Object)shardName);
        return cookie != null ? cookie : this.populateShard(shardName);
    }

    private synchronized @NonNull Long populateShard(String shardName) {
        Long cookie = (Long)this.shards.get((Object)shardName);
        if (cookie == null) {
            cookie = this.nextShard++;
            this.shards = ImmutableBiMap.builder().putAll(this.shards).put((Object)shardName, (Object)cookie).build();
        }
        return cookie;
    }

    public CompletionStage<ShardBackendInfo> getBackendInfo(Long cookie) {
        AbstractShardBackendResolver.ShardState existing = (AbstractShardBackendResolver.ShardState)this.backends.get(cookie);
        if (existing != null) {
            return existing.getStage();
        }
        String shardName = (String)this.shards.inverse().get((Object)cookie);
        if (shardName == null) {
            LOG.warn("Failing request for non-existent cookie {}", (Object)cookie);
            throw new IllegalArgumentException("Cookie " + cookie + " does not have a shard assigned");
        }
        LOG.debug("Resolving cookie {} to shard {}", (Object)cookie, (Object)shardName);
        AbstractShardBackendResolver.ShardState toInsert = this.resolveBackendInfo(shardName, cookie);
        AbstractShardBackendResolver.ShardState raced = this.backends.putIfAbsent(cookie, toInsert);
        if (raced != null) {
            LOG.debug("Race during insertion of state for cookie {} shard {}", (Object)cookie, (Object)shardName);
            return raced.getStage();
        }
        CompletionStage<ShardBackendInfo> stage = toInsert.getStage();
        stage.whenComplete((info, failure) -> {
            if (failure != null) {
                LOG.debug("Resolution of cookie {} shard {} failed, removing state", new Object[]{cookie, shardName, failure});
                this.backends.remove(cookie, toInsert);
                this.flushCache(shardName);
            }
        });
        return stage;
    }

    public CompletionStage<ShardBackendInfo> refreshBackendInfo(Long cookie, ShardBackendInfo staleInfo) {
        AbstractShardBackendResolver.ShardState existing = (AbstractShardBackendResolver.ShardState)this.backends.get(cookie);
        if (existing != null) {
            if (!staleInfo.equals((Object)existing.getResult())) {
                return existing.getStage();
            }
            LOG.debug("Invalidating backend information {}", (Object)staleInfo);
            this.flushCache(staleInfo.getName());
            LOG.trace("Invalidated cache {}", (Object)staleInfo);
            this.backends.remove(cookie, existing);
        }
        return this.getBackendInfo(cookie);
    }

    public void close() {
        this.shardAvailabilityChangesRegFuture.onComplete((Function1)new OnComplete<Registration>(this){

            public void onComplete(Throwable failure, Registration reply) {
                reply.close();
            }
        }, (ExecutionContext)ExecutionContexts.global());
    }

    public String resolveCookieName(Long cookie) {
        return (String)Verify.verifyNotNull((Object)((String)this.shards.inverse().get((Object)cookie)), (String)"Unexpected null cookie: %s", (Object[])new Object[]{cookie});
    }
}

