/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Status;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.mdsal.common.api.PostCanCommitStep;
import org.opendaylight.mdsal.common.api.PostPreCommitStep;
import org.opendaylight.mdsal.common.api.ThreePhaseCommitStep;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCandidate;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

final class DataTreeCohortActor
extends AbstractUntypedActor {
    private final Idle idleState = new Idle();
    private final DOMDataTreeCommitCohort cohort;
    private final YangInstanceIdentifier registeredPath;
    private final Map<TransactionIdentifier, CohortBehaviour<?, ?>> currentStateMap = new HashMap();

    private DataTreeCohortActor(DOMDataTreeCommitCohort cohort, YangInstanceIdentifier registeredPath) {
        this.cohort = Objects.requireNonNull(cohort);
        this.registeredPath = Objects.requireNonNull(registeredPath);
    }

    protected void handleReceive(Object message) {
        if (!(message instanceof CommitProtocolCommand)) {
            this.unknownMessage(message);
            return;
        }
        CommitProtocolCommand command = (CommitProtocolCommand)message;
        CohortBehaviour currentState = this.currentStateMap.computeIfAbsent(command.getTxId(), key -> this.idleState);
        this.LOG.debug("handleReceive for cohort {} - currentState: {}, message: {}", new Object[]{this.cohort.getClass().getName(), currentState, message});
        currentState.handle(command);
    }

    static Props props(DOMDataTreeCommitCohort cohort, YangInstanceIdentifier registeredPath) {
        return Props.create(DataTreeCohortActor.class, (Object[])new Object[]{cohort, registeredPath});
    }

    private class Idle
    extends CohortBehaviour<CanCommit, PostCanCommitStep> {
        Idle() {
            super(CanCommit.class);
        }

        @Override
        ListenableFuture<PostCanCommitStep> process(CanCommit message) {
            return DataTreeCohortActor.this.cohort.canCommit((Object)message.getTxId(), message.getSchema(), message.getCandidates());
        }

        @Override
        CohortBehaviour<?, ?> nextBehaviour(TransactionIdentifier txId, PostCanCommitStep nextStep) {
            return new PostCanCommit(txId, nextStep);
        }

        @Override
        ListenableFuture<?> abort() {
            return ThreePhaseCommitStep.NOOP_ABORT_FUTURE;
        }
    }

    static abstract class CommitProtocolCommand<R extends CommitReply> {
        private final TransactionIdentifier txId;

        final TransactionIdentifier getTxId() {
            return this.txId;
        }

        protected CommitProtocolCommand(TransactionIdentifier txId) {
            this.txId = Objects.requireNonNull(txId);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [txId=" + String.valueOf(this.txId) + "]";
        }
    }

    private abstract class CohortBehaviour<M extends CommitProtocolCommand<?>, S extends ThreePhaseCommitStep> {
        private final Class<M> handledMessageType;

        CohortBehaviour(Class<M> handledMessageType) {
            this.handledMessageType = Objects.requireNonNull(handledMessageType);
        }

        void handle(CommitProtocolCommand<?> command) {
            if (this.handledMessageType.isInstance(command)) {
                this.onMessage(command);
            } else if (command instanceof Abort) {
                this.onAbort(((Abort)command).getTxId());
            } else {
                DataTreeCohortActor.this.getSender().tell((Object)new Status.Failure((Throwable)new IllegalArgumentException(String.format("Unexpected message %s in cohort behavior %s", command.getClass(), this.getClass().getSimpleName()))), DataTreeCohortActor.this.getSelf());
            }
        }

        private void onMessage(CommitProtocolCommand<?> message) {
            final ActorRef sender = DataTreeCohortActor.this.getSender();
            final TransactionIdentifier txId = message.getTxId();
            ListenableFuture<S> future = this.process((CommitProtocolCommand)this.handledMessageType.cast(message));
            Executor callbackExecutor = future.isDone() ? MoreExecutors.directExecutor() : arg_0 -> ((DataTreeCohortActor)DataTreeCohortActor.this).executeInSelf(arg_0);
            Futures.addCallback(future, (FutureCallback)new FutureCallback<S>(){

                public void onSuccess(S nextStep) {
                    CohortBehaviour.this.success(txId, sender, nextStep);
                }

                public void onFailure(Throwable failure) {
                    CohortBehaviour.this.failed(txId, sender, failure);
                }
            }, (Executor)callbackExecutor);
        }

        private void failed(TransactionIdentifier txId, ActorRef sender, Throwable failure) {
            DataTreeCohortActor.this.currentStateMap.remove(txId);
            sender.tell((Object)new Status.Failure(failure), DataTreeCohortActor.this.getSelf());
        }

        private void success(TransactionIdentifier txId, ActorRef sender, S nextStep) {
            DataTreeCohortActor.this.currentStateMap.computeIfPresent(txId, (key, behaviour) -> this.nextBehaviour(txId, nextStep));
            sender.tell((Object)new Success(DataTreeCohortActor.this.getSelf(), txId), DataTreeCohortActor.this.getSelf());
        }

        private void onAbort(final TransactionIdentifier txId) {
            DataTreeCohortActor.this.currentStateMap.remove(txId);
            final ActorRef sender = DataTreeCohortActor.this.getSender();
            Futures.addCallback(this.abort(), (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object noop) {
                    sender.tell((Object)new Success(DataTreeCohortActor.this.getSelf(), txId), DataTreeCohortActor.this.getSelf());
                }

                public void onFailure(Throwable failure) {
                    DataTreeCohortActor.this.LOG.warn("Abort of transaction {} failed for cohort {}", new Object[]{txId, DataTreeCohortActor.this.cohort, failure});
                    sender.tell((Object)new Status.Failure(failure), DataTreeCohortActor.this.getSelf());
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        abstract @Nullable CohortBehaviour<?, ?> nextBehaviour(TransactionIdentifier var1, S var2);

        abstract @NonNull ListenableFuture<S> process(M var1);

        abstract ListenableFuture<?> abort();

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static interface NoopThreePhaseCommitStep
    extends ThreePhaseCommitStep {
    }

    private class PostPreCommit
    extends CohortStateWithStep<Commit, PostPreCommitStep, NoopThreePhaseCommitStep> {
        PostPreCommit(DataTreeCohortActor dataTreeCohortActor, TransactionIdentifier txId, PostPreCommitStep step) {
            super(dataTreeCohortActor, Commit.class, txId, (ThreePhaseCommitStep)step);
        }

        @Override
        ListenableFuture<NoopThreePhaseCommitStep> process(Commit message) {
            return ((PostPreCommitStep)this.getStep()).commit();
        }

        @Override
        CohortBehaviour<?, ?> nextBehaviour(TransactionIdentifier txId, NoopThreePhaseCommitStep nextStep) {
            return null;
        }
    }

    private class PostCanCommit
    extends CohortStateWithStep<PreCommit, PostCanCommitStep, PostPreCommitStep> {
        PostCanCommit(TransactionIdentifier txId, PostCanCommitStep nextStep) {
            super(DataTreeCohortActor.this, PreCommit.class, txId, (ThreePhaseCommitStep)nextStep);
        }

        @Override
        ListenableFuture<PostPreCommitStep> process(PreCommit message) {
            return ((PostCanCommitStep)this.getStep()).preCommit();
        }

        @Override
        CohortBehaviour<?, ?> nextBehaviour(TransactionIdentifier txId, PostPreCommitStep nextStep) {
            return new PostPreCommit(DataTreeCohortActor.this, txId, nextStep);
        }
    }

    private abstract class CohortStateWithStep<M extends CommitProtocolCommand<?>, S extends ThreePhaseCommitStep, N extends ThreePhaseCommitStep>
    extends CohortBehaviour<M, N> {
        private final S step;
        private final TransactionIdentifier txId;

        CohortStateWithStep(Class<M> handledMessageType, TransactionIdentifier txId, S step) {
            super(handledMessageType);
            this.txId = Objects.requireNonNull(txId);
            this.step = (ThreePhaseCommitStep)Objects.requireNonNull(step);
        }

        final S getStep() {
            return this.step;
        }

        @Override
        ListenableFuture<?> abort() {
            return this.getStep().abort();
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + " [txId=" + String.valueOf(this.txId) + ", step=" + String.valueOf(this.step) + "]";
        }
    }

    static final class Commit
    extends CommitProtocolCommand<Success> {
        Commit(TransactionIdentifier txId) {
            super(txId);
        }
    }

    static final class Abort
    extends CommitProtocolCommand<Success> {
        Abort(TransactionIdentifier txId) {
            super(txId);
        }
    }

    static final class PreCommit
    extends CommitProtocolCommand<Success> {
        PreCommit(TransactionIdentifier txId) {
            super(txId);
        }
    }

    static final class Success
    extends CommitReply {
        Success(ActorRef cohortRef, TransactionIdentifier txId) {
            super(cohortRef, txId);
        }
    }

    static abstract class CommitReply {
        private final ActorRef cohortRef;
        private final TransactionIdentifier txId;

        protected CommitReply(ActorRef cohortRef, TransactionIdentifier txId) {
            this.cohortRef = Objects.requireNonNull(cohortRef);
            this.txId = Objects.requireNonNull(txId);
        }

        ActorRef getCohort() {
            return this.cohortRef;
        }

        final TransactionIdentifier getTxId() {
            return this.txId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [txId=" + String.valueOf(this.txId) + ", cohortRef=" + String.valueOf(this.cohortRef) + "]";
        }
    }

    static final class CanCommit
    extends CommitProtocolCommand<Success> {
        private final Collection<DOMDataTreeCandidate> candidates;
        private final ActorRef cohort;
        private final EffectiveModelContext schema;

        CanCommit(TransactionIdentifier txId, Collection<DOMDataTreeCandidate> candidates, EffectiveModelContext schema, ActorRef cohort) {
            super(txId);
            this.cohort = Objects.requireNonNull(cohort);
            this.candidates = Objects.requireNonNull(candidates);
            this.schema = Objects.requireNonNull(schema);
        }

        Collection<DOMDataTreeCandidate> getCandidates() {
            return this.candidates;
        }

        EffectiveModelContext getSchema() {
            return this.schema;
        }

        ActorRef getCohort() {
            return this.cohort;
        }

        @Override
        public String toString() {
            return "CanCommit [txId=" + String.valueOf(this.getTxId()) + ", candidates=" + String.valueOf(this.candidates) + ", cohort=" + String.valueOf(this.cohort) + "]";
        }
    }
}

