/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.controller.cluster.datastore.DataTreeCohortActor;
import org.opendaylight.controller.cluster.datastore.DataTreeCohortActorRegistry;
import org.opendaylight.controller.cluster.datastore.exceptions.LocalShardNotFoundException;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;

public class DataTreeCohortRegistrationProxy<C extends DOMDataTreeCommitCohort>
extends AbstractObjectRegistration<C> {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeCohortRegistrationProxy.class);
    private static final Timeout TIMEOUT = new Timeout(new FiniteDuration(5L, TimeUnit.SECONDS));
    private final DOMDataTreeIdentifier subtree;
    private final ActorRef actor;
    private final ActorUtils actorUtils;
    private @GuardedBy(value={"this"}) ActorRef cohortRegistry;

    DataTreeCohortRegistrationProxy(ActorUtils actorUtils, DOMDataTreeIdentifier subtree, C cohort) {
        super(cohort);
        this.subtree = Objects.requireNonNull(subtree);
        this.actorUtils = Objects.requireNonNull(actorUtils);
        this.actor = actorUtils.getActorSystem().actorOf(DataTreeCohortActor.props((DOMDataTreeCommitCohort)this.getInstance(), subtree.path()).withDispatcher(actorUtils.getNotificationDispatcherPath()));
    }

    public void init(final String shardName) {
        Future<ActorRef> findFuture = this.actorUtils.findLocalShardAsync(shardName);
        findFuture.onComplete((Function1)new OnComplete<ActorRef>(){

            public void onComplete(Throwable failure, ActorRef shard) {
                if (failure instanceof LocalShardNotFoundException) {
                    LOG.debug("No local shard found for {} - DataTreeChangeListener {} at path {} cannot be registered", new Object[]{shardName, DataTreeCohortRegistrationProxy.this.getInstance(), DataTreeCohortRegistrationProxy.this.subtree});
                } else if (failure != null) {
                    LOG.error("Failed to find local shard {} - DataTreeChangeListener {} at path {} cannot be registered", new Object[]{shardName, DataTreeCohortRegistrationProxy.this.getInstance(), DataTreeCohortRegistrationProxy.this.subtree, failure});
                } else {
                    DataTreeCohortRegistrationProxy.this.performRegistration(shard);
                }
            }
        }, this.actorUtils.getClientDispatcher());
    }

    private synchronized void performRegistration(ActorRef shard) {
        if (this.isClosed()) {
            return;
        }
        this.cohortRegistry = shard;
        Future future = Patterns.ask((ActorRef)shard, (Object)new DataTreeCohortActorRegistry.RegisterCohort(this.subtree, this.actor), (Timeout)TIMEOUT);
        future.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object val) {
                if (failure != null) {
                    LOG.error("Unable to register {} as commit cohort", DataTreeCohortRegistrationProxy.this.getInstance(), (Object)failure);
                }
                if (DataTreeCohortRegistrationProxy.this.isClosed()) {
                    DataTreeCohortRegistrationProxy.this.removeRegistration();
                }
            }
        }, this.actorUtils.getClientDispatcher());
    }

    protected synchronized void removeRegistration() {
        if (this.cohortRegistry != null) {
            this.cohortRegistry.tell((Object)new DataTreeCohortActorRegistry.RemoveCohort(this.actor), ActorRef.noSender());
        }
    }
}

