/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.util.Timeout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.text.WordUtils;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.ClientActorConfig;
import org.opendaylight.controller.cluster.common.actor.AkkaConfigurationReader;
import org.opendaylight.controller.cluster.common.actor.FileAkkaConfigurationReader;
import org.opendaylight.controller.cluster.raft.ConfigParams;
import org.opendaylight.controller.cluster.raft.DefaultConfigParamsImpl;
import org.opendaylight.controller.cluster.raft.PeerAddressResolver;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev231229.DataStoreProperties;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.FiniteDuration;

public class DatastoreContext
implements ClientActorConfig {
    public static final String METRICS_DOMAIN = "org.opendaylight.controller.cluster.datastore";
    public static final FiniteDuration DEFAULT_SHARD_TRANSACTION_IDLE_TIMEOUT = FiniteDuration.create((long)10L, (TimeUnit)TimeUnit.MINUTES);
    public static final int DEFAULT_OPERATION_TIMEOUT_IN_MS = 5000;
    public static final int DEFAULT_SHARD_TX_COMMIT_TIMEOUT_IN_SECONDS = 30;
    public static final int DEFAULT_JOURNAL_RECOVERY_BATCH_SIZE = 1;
    public static final int DEFAULT_SNAPSHOT_BATCH_COUNT = 20000;
    public static final int DEFAULT_RECOVERY_SNAPSHOT_INTERVAL_SECONDS = 0;
    public static final int DEFAULT_HEARTBEAT_INTERVAL_IN_MILLIS = 500;
    public static final int DEFAULT_ISOLATED_LEADER_CHECK_INTERVAL_IN_MILLIS = 5000;
    public static final int DEFAULT_SHARD_TX_COMMIT_QUEUE_CAPACITY = 50000;
    public static final Timeout DEFAULT_SHARD_INITIALIZATION_TIMEOUT = new Timeout(5L, TimeUnit.MINUTES);
    public static final Timeout DEFAULT_SHARD_LEADER_ELECTION_TIMEOUT = new Timeout(30L, TimeUnit.SECONDS);
    public static final int DEFAULT_INITIAL_SETTLE_TIMEOUT_MULTIPLIER = 3;
    public static final boolean DEFAULT_PERSISTENT = true;
    public static final boolean DEFAULT_SNAPSHOT_ON_ROOT_OVERWRITE = false;
    public static final FileAkkaConfigurationReader DEFAULT_CONFIGURATION_READER = new FileAkkaConfigurationReader();
    public static final int DEFAULT_SHARD_SNAPSHOT_DATA_THRESHOLD_PERCENTAGE = 12;
    public static final int DEFAULT_SHARD_SNAPSHOT_DATA_THRESHOLD = 0;
    public static final int DEFAULT_SHARD_ELECTION_TIMEOUT_FACTOR = 2;
    public static final int DEFAULT_SHARD_CANDIDATE_ELECTION_TIMEOUT_DIVISOR = 1;
    public static final int DEFAULT_TX_CREATION_INITIAL_RATE_LIMIT = 100;
    public static final String UNKNOWN_DATA_STORE_TYPE = "unknown";
    public static final int DEFAULT_SHARD_BATCHED_MODIFICATION_COUNT = 1000;
    public static final long DEFAULT_SHARD_COMMIT_QUEUE_EXPIRY_TIMEOUT_IN_MS = TimeUnit.MILLISECONDS.convert(2L, TimeUnit.MINUTES);
    public static final int DEFAULT_MAX_MESSAGE_SLICE_SIZE = 491520;
    public static final int DEFAULT_INITIAL_PAYLOAD_SERIALIZED_BUFFER_CAPACITY = 512;
    public static final DataStoreProperties.ExportOnRecovery DEFAULT_EXPORT_ON_RECOVERY = DataStoreProperties.ExportOnRecovery.Off;
    public static final String DEFAULT_RECOVERY_EXPORT_BASE_DIR = "persistence-export";
    public static final long DEFAULT_SYNC_INDEX_THRESHOLD = 10L;
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreContext.class);
    private static final Set<String> GLOBAL_DATASTORE_NAMES = ConcurrentHashMap.newKeySet();
    private final DefaultConfigParamsImpl raftConfig = new DefaultConfigParamsImpl();
    private FiniteDuration shardTransactionIdleTimeout = DEFAULT_SHARD_TRANSACTION_IDLE_TIMEOUT;
    private long operationTimeoutInMillis = 5000L;
    private String dataStoreMXBeanType;
    private int shardTransactionCommitTimeoutInSeconds = 30;
    private int shardTransactionCommitQueueCapacity = 50000;
    private Timeout shardInitializationTimeout = DEFAULT_SHARD_INITIALIZATION_TIMEOUT;
    private Timeout shardLeaderElectionTimeout = DEFAULT_SHARD_LEADER_ELECTION_TIMEOUT;
    private int initialSettleTimeoutMultiplier = 3;
    private boolean persistent = true;
    private boolean snapshotOnRootOverwrite = false;
    private AkkaConfigurationReader configurationReader = DEFAULT_CONFIGURATION_READER;
    private long transactionCreationInitialRateLimit = 100L;
    private String dataStoreName = "unknown";
    private LogicalDatastoreType logicalStoreType = LogicalDatastoreType.OPERATIONAL;
    private YangInstanceIdentifier storeRoot = YangInstanceIdentifier.of();
    private int shardBatchedModificationCount = 1000;
    private boolean writeOnlyTransactionOptimizationsEnabled = true;
    private long shardCommitQueueExpiryTimeoutInMillis = DEFAULT_SHARD_COMMIT_QUEUE_EXPIRY_TIMEOUT_IN_MS;
    private boolean transactionDebugContextEnabled = false;
    private String shardManagerPersistenceId;
    private int maximumMessageSliceSize = 491520;
    private long backendAlivenessTimerInterval = AbstractClientConnection.DEFAULT_BACKEND_ALIVE_TIMEOUT_NANOS;
    private long requestTimeout = AbstractClientConnection.DEFAULT_REQUEST_TIMEOUT_NANOS;
    private long noProgressTimeout = AbstractClientConnection.DEFAULT_NO_PROGRESS_TIMEOUT_NANOS;
    private int initialPayloadSerializedBufferCapacity = 512;
    private boolean useLz4Compression = false;
    private DataStoreProperties.ExportOnRecovery exportOnRecovery = DEFAULT_EXPORT_ON_RECOVERY;
    private String recoveryExportBaseDir = "persistence-export";

    public static Set<String> getGlobalDatastoreNames() {
        return GLOBAL_DATASTORE_NAMES;
    }

    DatastoreContext() {
        this.setShardJournalRecoveryLogBatchSize(1);
        this.setSnapshotBatchCount(20000L);
        this.setRecoverySnapshotIntervalSeconds(0);
        this.setHeartbeatInterval(500L);
        this.setIsolatedLeaderCheckInterval(5000L);
        this.setSnapshotDataThresholdPercentage(12);
        this.setSnapshotDataThreshold(0);
        this.setElectionTimeoutFactor(2L);
        this.setCandidateElectionTimeoutDivisor(1L);
        this.setSyncIndexThreshold(10L);
        this.setMaximumMessageSliceSize(491520);
    }

    private DatastoreContext(DatastoreContext other) {
        this.shardTransactionIdleTimeout = other.shardTransactionIdleTimeout;
        this.operationTimeoutInMillis = other.operationTimeoutInMillis;
        this.dataStoreMXBeanType = other.dataStoreMXBeanType;
        this.shardTransactionCommitTimeoutInSeconds = other.shardTransactionCommitTimeoutInSeconds;
        this.shardTransactionCommitQueueCapacity = other.shardTransactionCommitQueueCapacity;
        this.shardInitializationTimeout = other.shardInitializationTimeout;
        this.shardLeaderElectionTimeout = other.shardLeaderElectionTimeout;
        this.initialSettleTimeoutMultiplier = other.initialSettleTimeoutMultiplier;
        this.persistent = other.persistent;
        this.snapshotOnRootOverwrite = other.snapshotOnRootOverwrite;
        this.configurationReader = other.configurationReader;
        this.transactionCreationInitialRateLimit = other.transactionCreationInitialRateLimit;
        this.dataStoreName = other.dataStoreName;
        this.logicalStoreType = other.logicalStoreType;
        this.storeRoot = other.storeRoot;
        this.shardBatchedModificationCount = other.shardBatchedModificationCount;
        this.writeOnlyTransactionOptimizationsEnabled = other.writeOnlyTransactionOptimizationsEnabled;
        this.shardCommitQueueExpiryTimeoutInMillis = other.shardCommitQueueExpiryTimeoutInMillis;
        this.transactionDebugContextEnabled = other.transactionDebugContextEnabled;
        this.shardManagerPersistenceId = other.shardManagerPersistenceId;
        this.backendAlivenessTimerInterval = other.backendAlivenessTimerInterval;
        this.requestTimeout = other.requestTimeout;
        this.noProgressTimeout = other.noProgressTimeout;
        this.initialPayloadSerializedBufferCapacity = other.initialPayloadSerializedBufferCapacity;
        this.useLz4Compression = other.useLz4Compression;
        this.exportOnRecovery = other.exportOnRecovery;
        this.recoveryExportBaseDir = other.recoveryExportBaseDir;
        this.setShardJournalRecoveryLogBatchSize(other.raftConfig.getJournalRecoveryLogBatchSize());
        this.setSnapshotBatchCount(other.raftConfig.getSnapshotBatchCount());
        this.setRecoverySnapshotIntervalSeconds(other.raftConfig.getRecoverySnapshotIntervalSeconds());
        this.setHeartbeatInterval(other.raftConfig.getHeartBeatInterval().toMillis());
        this.setIsolatedLeaderCheckInterval(other.raftConfig.getIsolatedCheckIntervalInMillis());
        this.setSnapshotDataThresholdPercentage(other.raftConfig.getSnapshotDataThresholdPercentage());
        this.setSnapshotDataThreshold(other.raftConfig.getSnapshotDataThreshold());
        this.setElectionTimeoutFactor(other.raftConfig.getElectionTimeoutFactor());
        this.setCandidateElectionTimeoutDivisor(other.raftConfig.getCandidateElectionTimeoutDivisor());
        this.setCustomRaftPolicyImplementation(other.raftConfig.getCustomRaftPolicyImplementationClass());
        this.setMaximumMessageSliceSize(other.getMaximumMessageSliceSize());
        this.setPeerAddressResolver(other.raftConfig.getPeerAddressResolver());
        this.setTempFileDirectory(other.getTempFileDirectory());
        this.setFileBackedStreamingThreshold(other.getFileBackedStreamingThreshold());
        this.setSyncIndexThreshold(other.raftConfig.getSyncIndexThreshold());
    }

    public static Builder newBuilder() {
        return new Builder(new DatastoreContext());
    }

    public static Builder newBuilderFrom(DatastoreContext context) {
        return new Builder(new DatastoreContext(context));
    }

    public FiniteDuration getShardTransactionIdleTimeout() {
        return this.shardTransactionIdleTimeout;
    }

    public String getDataStoreMXBeanType() {
        return this.dataStoreMXBeanType;
    }

    public long getOperationTimeoutInMillis() {
        return this.operationTimeoutInMillis;
    }

    public ConfigParams getShardRaftConfig() {
        return this.raftConfig;
    }

    public int getShardTransactionCommitTimeoutInSeconds() {
        return this.shardTransactionCommitTimeoutInSeconds;
    }

    public int getShardTransactionCommitQueueCapacity() {
        return this.shardTransactionCommitQueueCapacity;
    }

    public Timeout getShardInitializationTimeout() {
        return this.shardInitializationTimeout;
    }

    public Timeout getShardLeaderElectionTimeout() {
        return this.shardLeaderElectionTimeout;
    }

    public int getInitialSettleTimeoutMultiplier() {
        return this.initialSettleTimeoutMultiplier;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isSnapshotOnRootOverwrite() {
        return this.snapshotOnRootOverwrite;
    }

    public AkkaConfigurationReader getConfigurationReader() {
        return this.configurationReader;
    }

    public long getShardElectionTimeoutFactor() {
        return this.raftConfig.getElectionTimeoutFactor();
    }

    public String getDataStoreName() {
        return this.dataStoreName;
    }

    public LogicalDatastoreType getLogicalStoreType() {
        return this.logicalStoreType;
    }

    public YangInstanceIdentifier getStoreRoot() {
        return this.storeRoot;
    }

    public long getTransactionCreationInitialRateLimit() {
        return this.transactionCreationInitialRateLimit;
    }

    public String getShardManagerPersistenceId() {
        return this.shardManagerPersistenceId;
    }

    public String getTempFileDirectory() {
        return this.raftConfig.getTempFileDirectory();
    }

    private void setTempFileDirectory(String tempFileDirectory) {
        this.raftConfig.setTempFileDirectory(tempFileDirectory);
    }

    public int getFileBackedStreamingThreshold() {
        return this.raftConfig.getFileBackedStreamingThreshold();
    }

    private void setFileBackedStreamingThreshold(int fileBackedStreamingThreshold) {
        this.raftConfig.setFileBackedStreamingThreshold(fileBackedStreamingThreshold);
    }

    private void setPeerAddressResolver(PeerAddressResolver resolver) {
        this.raftConfig.setPeerAddressResolver(resolver);
    }

    private void setHeartbeatInterval(long shardHeartbeatIntervalInMillis) {
        this.raftConfig.setHeartBeatInterval(new FiniteDuration(shardHeartbeatIntervalInMillis, TimeUnit.MILLISECONDS));
    }

    private void setShardJournalRecoveryLogBatchSize(int shardJournalRecoveryLogBatchSize) {
        this.raftConfig.setJournalRecoveryLogBatchSize(shardJournalRecoveryLogBatchSize);
    }

    private void setIsolatedLeaderCheckInterval(long shardIsolatedLeaderCheckIntervalInMillis) {
        this.raftConfig.setIsolatedLeaderCheckInterval(new FiniteDuration(shardIsolatedLeaderCheckIntervalInMillis, TimeUnit.MILLISECONDS));
    }

    private void setElectionTimeoutFactor(long shardElectionTimeoutFactor) {
        this.raftConfig.setElectionTimeoutFactor(shardElectionTimeoutFactor);
    }

    private void setCandidateElectionTimeoutDivisor(long candidateElectionTimeoutDivisor) {
        this.raftConfig.setCandidateElectionTimeoutDivisor(candidateElectionTimeoutDivisor);
    }

    private void setCustomRaftPolicyImplementation(String customRaftPolicyImplementation) {
        this.raftConfig.setCustomRaftPolicyImplementationClass(customRaftPolicyImplementation);
    }

    private void setSnapshotDataThresholdPercentage(int shardSnapshotDataThresholdPercentage) {
        Preconditions.checkArgument((shardSnapshotDataThresholdPercentage >= 0 && shardSnapshotDataThresholdPercentage <= 100 ? 1 : 0) != 0);
        this.raftConfig.setSnapshotDataThresholdPercentage(shardSnapshotDataThresholdPercentage);
    }

    private void setSnapshotDataThreshold(int shardSnapshotDataThreshold) {
        Preconditions.checkArgument((shardSnapshotDataThreshold >= 0 ? 1 : 0) != 0);
        this.raftConfig.setSnapshotDataThreshold(shardSnapshotDataThreshold);
    }

    private void setSnapshotBatchCount(long shardSnapshotBatchCount) {
        this.raftConfig.setSnapshotBatchCount(shardSnapshotBatchCount);
    }

    private void setRecoverySnapshotIntervalSeconds(int recoverySnapshotInterval) {
        this.raftConfig.setRecoverySnapshotIntervalSeconds(recoverySnapshotInterval);
    }

    private void setMaximumMessageSliceSize(int maximumMessageSliceSize) {
        this.raftConfig.setMaximumMessageSliceSize(maximumMessageSliceSize);
        this.maximumMessageSliceSize = maximumMessageSliceSize;
    }

    private void setSyncIndexThreshold(long syncIndexThreshold) {
        this.raftConfig.setSyncIndexThreshold(syncIndexThreshold);
    }

    public int getShardBatchedModificationCount() {
        return this.shardBatchedModificationCount;
    }

    public boolean isWriteOnlyTransactionOptimizationsEnabled() {
        return this.writeOnlyTransactionOptimizationsEnabled;
    }

    public long getShardCommitQueueExpiryTimeoutInMillis() {
        return this.shardCommitQueueExpiryTimeoutInMillis;
    }

    public boolean isTransactionDebugContextEnabled() {
        return this.transactionDebugContextEnabled;
    }

    public boolean isUseLz4Compression() {
        return this.useLz4Compression;
    }

    public DataStoreProperties.ExportOnRecovery getExportOnRecovery() {
        return this.exportOnRecovery;
    }

    public String getRecoveryExportBaseDir() {
        return this.recoveryExportBaseDir;
    }

    public int getMaximumMessageSliceSize() {
        return this.maximumMessageSliceSize;
    }

    public long getBackendAlivenessTimerInterval() {
        return this.backendAlivenessTimerInterval;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getNoProgressTimeout() {
        return this.noProgressTimeout;
    }

    public int getInitialPayloadSerializedBufferCapacity() {
        return this.initialPayloadSerializedBufferCapacity;
    }

    public static class Builder {
        private final DatastoreContext datastoreContext;

        Builder(DatastoreContext datastoreContext) {
            this.datastoreContext = datastoreContext;
        }

        public Builder boundedMailboxCapacity(int boundedMailboxCapacity) {
            return this;
        }

        public Builder enableMetricCapture(boolean enableMetricCapture) {
            return this;
        }

        public Builder shardTransactionIdleTimeout(long timeout, TimeUnit unit) {
            this.datastoreContext.shardTransactionIdleTimeout = FiniteDuration.create((long)timeout, (TimeUnit)unit);
            return this;
        }

        public Builder shardTransactionIdleTimeoutInMinutes(long timeout) {
            return this.shardTransactionIdleTimeout(timeout, TimeUnit.MINUTES);
        }

        public Builder operationTimeoutInSeconds(int operationTimeoutInSeconds) {
            this.datastoreContext.operationTimeoutInMillis = TimeUnit.SECONDS.toMillis(operationTimeoutInSeconds);
            return this;
        }

        public Builder operationTimeoutInMillis(long operationTimeoutInMillis) {
            this.datastoreContext.operationTimeoutInMillis = operationTimeoutInMillis;
            return this;
        }

        public Builder dataStoreMXBeanType(String dataStoreMXBeanType) {
            this.datastoreContext.dataStoreMXBeanType = dataStoreMXBeanType;
            return this;
        }

        public Builder shardTransactionCommitTimeoutInSeconds(int shardTransactionCommitTimeoutInSeconds) {
            this.datastoreContext.shardTransactionCommitTimeoutInSeconds = shardTransactionCommitTimeoutInSeconds;
            return this;
        }

        public Builder shardJournalRecoveryLogBatchSize(int shardJournalRecoveryLogBatchSize) {
            this.datastoreContext.setShardJournalRecoveryLogBatchSize(shardJournalRecoveryLogBatchSize);
            return this;
        }

        public Builder shardSnapshotBatchCount(int shardSnapshotBatchCount) {
            this.datastoreContext.setSnapshotBatchCount(shardSnapshotBatchCount);
            return this;
        }

        public Builder recoverySnapshotIntervalSeconds(int recoverySnapshotIntervalSeconds) {
            Preconditions.checkArgument((recoverySnapshotIntervalSeconds >= 0 ? 1 : 0) != 0);
            this.datastoreContext.setRecoverySnapshotIntervalSeconds(recoverySnapshotIntervalSeconds);
            return this;
        }

        public Builder shardSnapshotDataThresholdPercentage(int shardSnapshotDataThresholdPercentage) {
            this.datastoreContext.setSnapshotDataThresholdPercentage(shardSnapshotDataThresholdPercentage);
            return this;
        }

        public Builder shardSnapshotDataThreshold(int shardSnapshotDataThreshold) {
            this.datastoreContext.setSnapshotDataThreshold(shardSnapshotDataThreshold);
            return this;
        }

        public Builder shardHeartbeatIntervalInMillis(int shardHeartbeatIntervalInMillis) {
            this.datastoreContext.setHeartbeatInterval(shardHeartbeatIntervalInMillis);
            return this;
        }

        public Builder shardTransactionCommitQueueCapacity(int shardTransactionCommitQueueCapacity) {
            this.datastoreContext.shardTransactionCommitQueueCapacity = shardTransactionCommitQueueCapacity;
            return this;
        }

        public Builder shardInitializationTimeout(long timeout, TimeUnit unit) {
            this.datastoreContext.shardInitializationTimeout = new Timeout(timeout, unit);
            return this;
        }

        public Builder shardInitializationTimeoutInSeconds(long timeout) {
            return this.shardInitializationTimeout(timeout, TimeUnit.SECONDS);
        }

        public Builder shardLeaderElectionTimeout(long timeout, TimeUnit unit) {
            this.datastoreContext.shardLeaderElectionTimeout = new Timeout(timeout, unit);
            return this;
        }

        public Builder initialSettleTimeoutMultiplier(int multiplier) {
            Preconditions.checkArgument((multiplier >= 0 ? 1 : 0) != 0);
            this.datastoreContext.initialSettleTimeoutMultiplier = multiplier;
            return this;
        }

        public Builder shardLeaderElectionTimeoutInSeconds(long timeout) {
            return this.shardLeaderElectionTimeout(timeout, TimeUnit.SECONDS);
        }

        public Builder configurationReader(AkkaConfigurationReader configurationReader) {
            this.datastoreContext.configurationReader = configurationReader;
            return this;
        }

        public Builder persistent(boolean persistent) {
            this.datastoreContext.persistent = persistent;
            return this;
        }

        public Builder snapshotOnRootOverwrite(boolean snapshotOnRootOverwrite) {
            this.datastoreContext.snapshotOnRootOverwrite = snapshotOnRootOverwrite;
            return this;
        }

        public Builder shardIsolatedLeaderCheckIntervalInMillis(int shardIsolatedLeaderCheckIntervalInMillis) {
            this.datastoreContext.setIsolatedLeaderCheckInterval(shardIsolatedLeaderCheckIntervalInMillis);
            return this;
        }

        public Builder shardElectionTimeoutFactor(long shardElectionTimeoutFactor) {
            this.datastoreContext.setElectionTimeoutFactor(shardElectionTimeoutFactor);
            return this;
        }

        public Builder shardCandidateElectionTimeoutDivisor(long candidateElectionTimeoutDivisor) {
            this.datastoreContext.setCandidateElectionTimeoutDivisor(candidateElectionTimeoutDivisor);
            return this;
        }

        public Builder transactionCreationInitialRateLimit(long initialRateLimit) {
            this.datastoreContext.transactionCreationInitialRateLimit = initialRateLimit;
            return this;
        }

        public Builder logicalStoreType(LogicalDatastoreType logicalStoreType) {
            this.datastoreContext.logicalStoreType = Objects.requireNonNull(logicalStoreType);
            switch (logicalStoreType) {
                case CONFIGURATION: {
                    this.dataStoreName("config");
                    break;
                }
                case OPERATIONAL: {
                    this.dataStoreName("operational");
                    break;
                }
                default: {
                    this.dataStoreName(logicalStoreType.name());
                }
            }
            return this;
        }

        public Builder storeRoot(YangInstanceIdentifier storeRoot) {
            this.datastoreContext.storeRoot = storeRoot;
            return this;
        }

        public Builder dataStoreName(String dataStoreName) {
            this.datastoreContext.dataStoreName = Objects.requireNonNull(dataStoreName);
            this.datastoreContext.dataStoreMXBeanType = "Distributed" + WordUtils.capitalize((String)dataStoreName) + "Datastore";
            return this;
        }

        public Builder shardBatchedModificationCount(int shardBatchedModificationCount) {
            this.datastoreContext.shardBatchedModificationCount = shardBatchedModificationCount;
            return this;
        }

        public Builder writeOnlyTransactionOptimizationsEnabled(boolean value) {
            this.datastoreContext.writeOnlyTransactionOptimizationsEnabled = value;
            return this;
        }

        public Builder shardCommitQueueExpiryTimeoutInMillis(long value) {
            this.datastoreContext.shardCommitQueueExpiryTimeoutInMillis = value;
            return this;
        }

        public Builder shardCommitQueueExpiryTimeoutInSeconds(long value) {
            this.datastoreContext.shardCommitQueueExpiryTimeoutInMillis = TimeUnit.MILLISECONDS.convert(value, TimeUnit.SECONDS);
            return this;
        }

        public Builder transactionDebugContextEnabled(boolean value) {
            this.datastoreContext.transactionDebugContextEnabled = value;
            return this;
        }

        public Builder useLz4Compression(boolean value) {
            this.datastoreContext.useLz4Compression = value;
            return this;
        }

        public Builder exportOnRecovery(DataStoreProperties.ExportOnRecovery value) {
            this.datastoreContext.exportOnRecovery = value;
            return this;
        }

        public Builder recoveryExportBaseDir(String value) {
            this.datastoreContext.recoveryExportBaseDir = value;
            return this;
        }

        @VisibleForTesting
        public Builder shardManagerPersistenceId(String id) {
            this.datastoreContext.shardManagerPersistenceId = id;
            return this;
        }

        public Builder customRaftPolicyImplementation(String customRaftPolicyImplementation) {
            this.datastoreContext.setCustomRaftPolicyImplementation(customRaftPolicyImplementation);
            return this;
        }

        public Builder maximumMessageSliceSize(int maximumMessageSliceSize) {
            this.datastoreContext.setMaximumMessageSliceSize(maximumMessageSliceSize);
            return this;
        }

        public Builder shardPeerAddressResolver(PeerAddressResolver resolver) {
            this.datastoreContext.setPeerAddressResolver(resolver);
            return this;
        }

        public Builder tempFileDirectory(String tempFileDirectory) {
            this.datastoreContext.setTempFileDirectory(tempFileDirectory);
            return this;
        }

        public Builder fileBackedStreamingThresholdInMegabytes(int fileBackedStreamingThreshold) {
            this.datastoreContext.setFileBackedStreamingThreshold(fileBackedStreamingThreshold * 0x100000);
            return this;
        }

        public Builder syncIndexThreshold(long syncIndexThreshold) {
            this.datastoreContext.setSyncIndexThreshold(syncIndexThreshold);
            return this;
        }

        public Builder backendAlivenessTimerIntervalInSeconds(long interval) {
            this.datastoreContext.backendAlivenessTimerInterval = TimeUnit.SECONDS.toNanos(interval);
            return this;
        }

        public Builder frontendRequestTimeoutInSeconds(long timeout) {
            this.datastoreContext.requestTimeout = TimeUnit.SECONDS.toNanos(timeout);
            return this;
        }

        public Builder frontendNoProgressTimeoutInSeconds(long timeout) {
            this.datastoreContext.noProgressTimeout = TimeUnit.SECONDS.toNanos(timeout);
            return this;
        }

        public Builder initialPayloadSerializedBufferCapacity(int capacity) {
            this.datastoreContext.initialPayloadSerializedBufferCapacity = capacity;
            return this;
        }

        public DatastoreContext build() {
            if (this.datastoreContext.dataStoreName != null) {
                GLOBAL_DATASTORE_NAMES.add(this.datastoreContext.dataStoreName);
            }
            return this.datastoreContext;
        }
    }
}

