/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.commands.CreateLocalHistoryRequest;
import org.opendaylight.controller.cluster.access.commands.DeadHistoryException;
import org.opendaylight.controller.cluster.access.commands.DestroyLocalHistoryRequest;
import org.opendaylight.controller.cluster.access.commands.LocalHistoryRequest;
import org.opendaylight.controller.cluster.access.commands.LocalHistorySuccess;
import org.opendaylight.controller.cluster.access.commands.OutOfSequenceEnvelopeException;
import org.opendaylight.controller.cluster.access.commands.PurgeLocalHistoryRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.UnknownHistoryException;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.access.concepts.UnsupportedRequestException;
import org.opendaylight.controller.cluster.datastore.AbstractFrontendHistory;
import org.opendaylight.controller.cluster.datastore.LocalFrontendHistory;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeTransactionChain;
import org.opendaylight.controller.cluster.datastore.SimpleShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.StandaloneFrontendHistory;
import org.opendaylight.controller.cluster.datastore.utils.MutableUnsignedLongSet;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract sealed class LeaderFrontendState
implements Identifiable<ClientIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderFrontendState.class);
    private final @NonNull ClientIdentifier clientId;
    private final @NonNull String persistenceId;
    private final @NonNull ShardDataTree tree;
    private long lastConnectTicks;
    private long lastSeenTicks;

    LeaderFrontendState(String persistenceId, ClientIdentifier clientId, ShardDataTree tree) {
        this.persistenceId = Objects.requireNonNull(persistenceId);
        this.clientId = Objects.requireNonNull(clientId);
        this.tree = Objects.requireNonNull(tree);
        this.lastSeenTicks = tree.readTime();
    }

    public final ClientIdentifier getIdentifier() {
        return this.clientId;
    }

    final String persistenceId() {
        return this.persistenceId;
    }

    final long getLastConnectTicks() {
        return this.lastConnectTicks;
    }

    final long getLastSeenTicks() {
        return this.lastSeenTicks;
    }

    final ShardDataTree tree() {
        return this.tree;
    }

    final void touch() {
        this.lastSeenTicks = this.tree.readTime();
    }

    abstract @Nullable LocalHistorySuccess handleLocalHistoryRequest(LocalHistoryRequest<?> var1, RequestEnvelope var2, long var3) throws RequestException;

    abstract @Nullable TransactionSuccess<?> handleTransactionRequest(TransactionRequest<?> var1, RequestEnvelope var2, long var3) throws RequestException;

    void reconnect() {
        this.lastConnectTicks = this.tree.readTime();
    }

    void retire() {
        Iterator<SimpleShardDataTreeCohort> it = this.tree.cohortIterator();
        while (it.hasNext()) {
            SimpleShardDataTreeCohort cohort = it.next();
            TransactionIdentifier transactionId = cohort.transactionId();
            if (!this.clientId.equals((Object)transactionId.getHistoryId().getClientId())) continue;
            if (cohort.getState() != ShardDataTreeCohort.State.COMMIT_PENDING) {
                LOG.debug("{}: Retiring transaction {}", (Object)this.persistenceId, (Object)transactionId);
                it.remove();
                continue;
            }
            LOG.debug("{}: Transaction {} already committing, not retiring it", (Object)this.persistenceId, (Object)transactionId);
        }
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("clientId", (Object)this.clientId).add("nanosAgo", this.tree.readTime() - this.lastSeenTicks);
    }

    static final class Enabled
    extends LeaderFrontendState {
        private final Map<LocalHistoryIdentifier, LocalFrontendHistory> localHistories;
        private final MutableUnsignedLongSet purgedHistories;
        private final AbstractFrontendHistory standaloneHistory;
        private long expectedTxSequence;
        private Long lastSeenHistory = null;

        Enabled(String persistenceId, ClientIdentifier clientId, ShardDataTree tree) {
            this(persistenceId, clientId, tree, MutableUnsignedLongSet.of(), StandaloneFrontendHistory.create(persistenceId, clientId, tree), new HashMap<LocalHistoryIdentifier, LocalFrontendHistory>());
        }

        Enabled(String persistenceId, ClientIdentifier clientId, ShardDataTree tree, MutableUnsignedLongSet purgedHistories, AbstractFrontendHistory standaloneHistory, Map<LocalHistoryIdentifier, LocalFrontendHistory> localHistories) {
            super(persistenceId, clientId, tree);
            this.purgedHistories = Objects.requireNonNull(purgedHistories);
            this.standaloneHistory = Objects.requireNonNull(standaloneHistory);
            this.localHistories = Objects.requireNonNull(localHistories);
        }

        @Override
        @Nullable LocalHistorySuccess handleLocalHistoryRequest(LocalHistoryRequest<?> request, RequestEnvelope envelope, long now) throws RequestException {
            this.checkRequestSequence(envelope);
            try {
                if (request instanceof CreateLocalHistoryRequest) {
                    CreateLocalHistoryRequest req = (CreateLocalHistoryRequest)request;
                    LocalHistorySuccess localHistorySuccess = this.handleCreateHistory(req, envelope, now);
                    return localHistorySuccess;
                }
                if (request instanceof DestroyLocalHistoryRequest) {
                    DestroyLocalHistoryRequest req = (DestroyLocalHistoryRequest)request;
                    LocalHistorySuccess localHistorySuccess = this.handleDestroyHistory(req, envelope, now);
                    return localHistorySuccess;
                }
                if (request instanceof PurgeLocalHistoryRequest) {
                    PurgeLocalHistoryRequest req = (PurgeLocalHistoryRequest)request;
                    LocalHistorySuccess localHistorySuccess = this.handlePurgeHistory(req, envelope, now);
                    return localHistorySuccess;
                }
                LOG.warn("{}: rejecting unsupported request {}", (Object)this.persistenceId(), request);
                throw new UnsupportedRequestException(request);
            }
            finally {
                this.expectNextRequest();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable TransactionSuccess<?> handleTransactionRequest(TransactionRequest<?> request, RequestEnvelope envelope, long now) throws RequestException {
            this.checkRequestSequence(envelope);
            try {
                AbstractFrontendHistory history;
                LocalHistoryIdentifier lhId = ((TransactionIdentifier)request.getTarget()).getHistoryId();
                if (lhId.getHistoryId() != 0L) {
                    history = this.localHistories.get(lhId);
                    if (history == null) {
                        if (this.purgedHistories.contains(lhId.getHistoryId())) {
                            LOG.warn("{}: rejecting request {} to purged history", (Object)this.persistenceId(), request);
                            throw new DeadHistoryException(this.purgedHistories.toRangeSet());
                        }
                        LOG.warn("{}: rejecting unknown history request {}", (Object)this.persistenceId(), request);
                        throw new UnknownHistoryException(this.lastSeenHistory);
                    }
                } else {
                    history = this.standaloneHistory;
                }
                TransactionSuccess<?> transactionSuccess = history.handleTransactionRequest(request, envelope, now);
                return transactionSuccess;
            }
            finally {
                this.expectNextRequest();
            }
        }

        @Override
        void reconnect() {
            this.expectedTxSequence = 0L;
            super.reconnect();
        }

        @Override
        void retire() {
            super.retire();
            this.localHistories.values().forEach(AbstractFrontendHistory::retire);
            this.localHistories.clear();
            this.standaloneHistory.retire();
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("purgedHistories", (Object)this.purgedHistories);
        }

        private LocalHistorySuccess handleCreateHistory(CreateLocalHistoryRequest request, RequestEnvelope envelope, long now) throws RequestException {
            LocalHistoryIdentifier historyId = (LocalHistoryIdentifier)request.getTarget();
            LocalFrontendHistory existing = this.localHistories.get(historyId);
            if (existing != null) {
                LOG.debug("{}: history {} already exists", (Object)this.persistenceId(), (Object)historyId);
                return new LocalHistorySuccess(historyId, request.getSequence());
            }
            if (this.purgedHistories.contains(historyId.getHistoryId())) {
                LOG.debug("{}: rejecting purged request {}", (Object)this.persistenceId(), (Object)request);
                throw new DeadHistoryException(this.purgedHistories.toRangeSet());
            }
            if (this.lastSeenHistory == null || Long.compareUnsigned(this.lastSeenHistory, historyId.getHistoryId()) < 0) {
                this.lastSeenHistory = historyId.getHistoryId();
            }
            ShardDataTreeTransactionChain chain = this.tree().ensureTransactionChain(historyId, () -> {
                LOG.debug("{}: persisted history {}", (Object)this.persistenceId(), (Object)historyId);
                envelope.sendSuccess((RequestSuccess)new LocalHistorySuccess(historyId, request.getSequence()), this.tree().readTime() - now);
            });
            this.localHistories.put(historyId, LocalFrontendHistory.create(this.persistenceId(), this.tree(), chain));
            LOG.debug("{}: created history {}", (Object)this.persistenceId(), (Object)historyId);
            return null;
        }

        private LocalHistorySuccess handleDestroyHistory(DestroyLocalHistoryRequest request, RequestEnvelope envelope, long now) {
            LocalHistoryIdentifier id = (LocalHistoryIdentifier)request.getTarget();
            LocalFrontendHistory existing = this.localHistories.get(id);
            if (existing == null) {
                LOG.debug("{}: history {} does not exist, nothing to destroy", (Object)this.persistenceId(), (Object)id);
                return new LocalHistorySuccess(id, request.getSequence());
            }
            existing.destroy(request.getSequence(), envelope, now);
            return null;
        }

        private LocalHistorySuccess handlePurgeHistory(PurgeLocalHistoryRequest request, RequestEnvelope envelope, long now) {
            LocalHistoryIdentifier id = (LocalHistoryIdentifier)request.getTarget();
            LocalFrontendHistory existing = this.localHistories.remove(id);
            if (existing == null) {
                LOG.debug("{}: history {} has already been purged", (Object)this.persistenceId(), (Object)id);
                return new LocalHistorySuccess(id, request.getSequence());
            }
            LOG.debug("{}: purging history {}", (Object)this.persistenceId(), (Object)id);
            this.purgedHistories.add(id.getHistoryId());
            existing.purge(request.getSequence(), envelope, now);
            return null;
        }

        private void checkRequestSequence(RequestEnvelope envelope) throws OutOfSequenceEnvelopeException {
            if (this.expectedTxSequence != envelope.getTxSequence()) {
                throw new OutOfSequenceEnvelopeException(this.expectedTxSequence);
            }
        }

        private void expectNextRequest() {
            ++this.expectedTxSequence;
        }
    }

    static final class Disabled
    extends LeaderFrontendState {
        Disabled(String persistenceId, ClientIdentifier clientId, ShardDataTree tree) {
            super(persistenceId, clientId, tree);
        }

        @Override
        LocalHistorySuccess handleLocalHistoryRequest(LocalHistoryRequest<?> request, RequestEnvelope envelope, long now) throws RequestException {
            throw new UnsupportedRequestException(request);
        }

        @Override
        TransactionSuccess<?> handleTransactionRequest(TransactionRequest<?> request, RequestEnvelope envelope, long now) throws RequestException {
            throw new UnsupportedRequestException(request);
        }
    }
}

