/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.Props;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.cluster.datastore.DataTreeChangeListenerActor;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeChanged;
import org.opendaylight.controller.cluster.datastore.messages.OnInitialData;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidateNodes;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidates;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

final class RootDataTreeChangeListenerActor
extends DataTreeChangeListenerActor {
    private final int shardCount;
    private Map<ActorRef, Object> initialMessages = new LinkedHashMap<ActorRef, Object>();
    private Deque<DataTreeChanged> otherMessages = new ArrayDeque<DataTreeChanged>();

    private RootDataTreeChangeListenerActor(DOMDataTreeChangeListener listener, int shardCount) {
        super(listener, YangInstanceIdentifier.of());
        this.shardCount = shardCount;
    }

    @Override
    void onInitialData(OnInitialData message) {
        ActorRef sender = this.getSender();
        Verify.verifyNotNull(this.initialMessages, (String)"Received OnInitialData from %s after initial convergence", (Object[])new Object[]{sender});
        Object prev = this.initialMessages.put(sender, message);
        Verify.verify((prev == null ? 1 : 0) != 0, (String)"Received OnInitialData from %s after %s", (Object)sender, (Object)prev);
        this.checkInitialConvergence();
    }

    @Override
    void dataTreeChanged(DataTreeChanged message) {
        if (this.initialMessages == null) {
            super.dataTreeChanged(message);
        } else {
            this.processMessage(message);
        }
    }

    private void processMessage(DataTreeChanged message) {
        if (this.initialMessages.putIfAbsent(this.getSender(), message) == null) {
            this.checkInitialConvergence();
        } else {
            this.otherMessages.addLast(message);
        }
    }

    private void checkInitialConvergence() {
        if (this.initialMessages.size() != this.shardCount) {
            return;
        }
        ArrayList<DataTreeCandidate> initialChanges = new ArrayList<DataTreeCandidate>();
        initialChanges.add(null);
        DataContainerNodeBuilder rootBuilder = Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)SchemaContext.NAME));
        for (Object message : this.initialMessages.values()) {
            DataTreeCandidate initial;
            if (!(message instanceof DataTreeChanged)) continue;
            List<DataTreeCandidate> changes = ((DataTreeChanged)message).getChanges();
            if (changes.size() != 1) {
                Iterator<DataTreeCandidate> it = changes.iterator();
                initial = (DataTreeCandidate)it.next();
                it.forEachRemaining(initialChanges::add);
            } else {
                initial = (DataTreeCandidate)Iterables.get(changes, (int)0);
            }
            NormalizedNode root = initial.getRootNode().getDataAfter();
            Verify.verify((boolean)(root instanceof ContainerNode), (String)"Unexpected root node %s", (Object)root);
            ((ContainerNode)root).body().forEach(arg_0 -> ((DataContainerNodeBuilder)rootBuilder).withChild(arg_0));
        }
        this.initialMessages = null;
        initialChanges.set(0, DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)YangInstanceIdentifier.of(), (DataTreeCandidateNode)DataTreeCandidateNodes.written((NormalizedNode)rootBuilder.build())));
        super.dataTreeChanged(new DataTreeChanged(initialChanges));
        DataTreeChanged message = this.otherMessages.poll();
        while (message != null) {
            super.dataTreeChanged(message);
            message = this.otherMessages.poll();
        }
        this.otherMessages = null;
    }

    static Props props(DOMDataTreeChangeListener instance, int shardCount) {
        return Props.create(RootDataTreeChangeListenerActor.class, (Object[])new Object[]{instance, shardCount});
    }
}

