/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.actors;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.PoisonPill;
import akka.actor.Props;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistration;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistrationReply;
import org.opendaylight.yangtools.concepts.Registration;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public final class DataTreeNotificationListenerRegistrationActor
extends AbstractUntypedActor {
    @VisibleForTesting
    static long killDelay = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
    private SetRegistration registration = null;
    private Cancellable killSchedule = null;
    private boolean closed;

    protected void handleReceive(Object message) {
        if (message instanceof CloseDataTreeNotificationListenerRegistration) {
            this.closeListenerRegistration();
            if (this.isValidSender(this.getSender())) {
                this.getSender().tell((Object)CloseDataTreeNotificationListenerRegistrationReply.getInstance(), this.getSelf());
            }
        } else if (message instanceof SetRegistration) {
            SetRegistration setRegistration;
            this.registration = setRegistration = (SetRegistration)message;
            if (this.closed) {
                this.closeListenerRegistration();
            }
        } else {
            this.unknownMessage(message);
        }
    }

    private void closeListenerRegistration() {
        this.closed = true;
        SetRegistration reg = this.registration;
        if (reg != null) {
            this.registration = null;
            reg.registration.close();
            reg.onClose.run();
            if (this.killSchedule == null) {
                this.killSchedule = this.getContext().system().scheduler().scheduleOnce(FiniteDuration.create((long)killDelay, (TimeUnit)TimeUnit.MILLISECONDS), this.getSelf(), (Object)PoisonPill.getInstance(), (ExecutionContext)this.getContext().dispatcher(), ActorRef.noSender());
            }
        }
    }

    public static Props props() {
        return Props.create(DataTreeNotificationListenerRegistrationActor.class, (Object[])new Object[0]);
    }

    @NonNullByDefault
    public record SetRegistration(Registration registration, Runnable onClose) {
        public SetRegistration {
            Objects.requireNonNull(registration);
            Objects.requireNonNull(onClose);
        }
    }
}

