/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.messages;

import akka.actor.ActorPath;
import akka.actor.ActorRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.SerializationUtils;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public final class RegisterDataTreeChangeListener
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private ActorRef dataTreeChangeListenerPath;
    private YangInstanceIdentifier path;
    private boolean registerOnAllInstances;

    public RegisterDataTreeChangeListener() {
    }

    public RegisterDataTreeChangeListener(YangInstanceIdentifier path, ActorRef dataTreeChangeListenerPath, boolean registerOnAllInstances) {
        this.path = Objects.requireNonNull(path);
        this.dataTreeChangeListenerPath = Objects.requireNonNull(dataTreeChangeListenerPath);
        this.registerOnAllInstances = registerOnAllInstances;
    }

    public YangInstanceIdentifier getPath() {
        return this.path;
    }

    public ActorPath getListenerActorPath() {
        return this.dataTreeChangeListenerPath.path();
    }

    public boolean isRegisterOnAllInstances() {
        return this.registerOnAllInstances;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.dataTreeChangeListenerPath);
        SerializationUtils.writePath((DataOutput)out, (YangInstanceIdentifier)this.path);
        out.writeBoolean(this.registerOnAllInstances);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dataTreeChangeListenerPath = (ActorRef)in.readObject();
        this.path = SerializationUtils.readPath((DataInput)in);
        this.registerOnAllInstances = in.readBoolean();
    }

    public String toString() {
        return "RegisterDataTreeChangeListener [path=" + String.valueOf(this.path) + ", registerOnAllInstances=" + this.registerOnAllInstances + ", dataTreeChangeListenerPath=" + String.valueOf(this.dataTreeChangeListenerPath) + "]";
    }
}

