/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataOutput;
import java.io.IOException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.AT;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AbortTransactionPayload
extends AbstractIdentifiablePayload<TransactionIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(AbortTransactionPayload.class);
    private static final long serialVersionUID = 1L;
    private static final int PROXY_SIZE = AbortTransactionPayload.externalizableProxySize(AT::new);

    AbortTransactionPayload(TransactionIdentifier transactionId, byte[] serialized) {
        super(transactionId, serialized);
    }

    public static AbortTransactionPayload create(TransactionIdentifier transactionId, int initialSerializedBufferCapacity) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)initialSerializedBufferCapacity);
        try {
            transactionId.writeTo((DataOutput)out);
        }
        catch (IOException e) {
            LOG.error("Failed to serialize {}", (Object)transactionId, (Object)e);
            throw new IllegalStateException("Failed to serialized " + String.valueOf(transactionId), e);
        }
        return new AbortTransactionPayload(transactionId, out.toByteArray());
    }

    @Override
    protected AT externalizableProxy(byte[] serialized) {
        return new AT(serialized);
    }

    @Override
    protected int externalizableProxySize() {
        return PROXY_SIZE;
    }
}

