/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.collect.ImmutableList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendClientMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendShardDataTreeSnapshotMetadata;

final class FM
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private List<FrontendClientMetadata> clients;

    public FM() {
    }

    FM(FrontendShardDataTreeSnapshotMetadata metadata) {
        this.clients = metadata.getClients();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.clients.size());
        for (FrontendClientMetadata c : this.clients) {
            c.writeTo(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            builder.add((Object)FrontendClientMetadata.readFrom(in));
        }
        this.clients = builder.build();
    }

    private Object readResolve() {
        return new FrontendShardDataTreeSnapshotMetadata(this.clients);
    }
}

