/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataOutput;
import java.io.IOException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractIdentifiablePayload;
import org.opendaylight.controller.cluster.datastore.persisted.PT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PurgeTransactionPayload
extends AbstractIdentifiablePayload<TransactionIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeTransactionPayload.class);
    private static final long serialVersionUID = 1L;
    private static final int PROXY_SIZE = PurgeTransactionPayload.externalizableProxySize(PT::new);

    PurgeTransactionPayload(TransactionIdentifier transactionId, byte[] serialized) {
        super(transactionId, serialized);
    }

    public static PurgeTransactionPayload create(TransactionIdentifier transactionId, int initialSerializedBufferCapacity) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput((int)initialSerializedBufferCapacity);
        try {
            transactionId.writeTo((DataOutput)out);
        }
        catch (IOException e) {
            LOG.error("Failed to serialize {}", (Object)transactionId, (Object)e);
            throw new IllegalStateException("Failed to serialize " + String.valueOf(transactionId), e);
        }
        return new PurgeTransactionPayload(transactionId, out.toByteArray());
    }

    @Override
    protected PT externalizableProxy(byte[] serialized) {
        return new PT(serialized);
    }

    @Override
    protected int externalizableProxySize() {
        return PROXY_SIZE;
    }
}

