/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.utils;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamException;
import org.opendaylight.controller.cluster.datastore.util.AbstractDataTreeModificationCursor;
import org.opendaylight.controller.cluster.datastore.utils.NormalizedNodeXMLOutput;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModificationCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataTreeModificationOutput {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeModificationOutput.class);

    private DataTreeModificationOutput() {
    }

    public static void toFile(File file, DataTreeModification modification) {
        try (FileOutputStream outStream = new FileOutputStream(file);){
            modification.applyToCursor((DataTreeModificationCursor)new DataTreeModificationOutputCursor(new DataOutputStream(outStream)));
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error writing DataTreeModification to file {}", (Object)file, (Object)e);
        }
    }

    private static class DataTreeModificationOutputCursor
    extends AbstractDataTreeModificationCursor {
        private final DataOutputStream output;

        DataTreeModificationOutputCursor(DataOutputStream output) {
            this.output = output;
        }

        public void delete(YangInstanceIdentifier.PathArgument child) {
            try {
                this.output.write("\nDELETE -> ".getBytes(StandardCharsets.UTF_8));
                this.output.write(this.current().node(child).toString().getBytes(StandardCharsets.UTF_8));
                this.output.writeByte(10);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public void merge(YangInstanceIdentifier.PathArgument child, NormalizedNode data) {
            this.outputPathAndNode("MERGE", child, data);
        }

        public void write(YangInstanceIdentifier.PathArgument child, NormalizedNode data) {
            this.outputPathAndNode("WRITE", child, data);
        }

        private void outputPathAndNode(String name, YangInstanceIdentifier.PathArgument child, NormalizedNode data) {
            try {
                this.output.writeByte(10);
                this.output.write(name.getBytes(StandardCharsets.UTF_8));
                this.output.write(" -> ".getBytes(StandardCharsets.UTF_8));
                this.output.write(this.current().node(child).toString().getBytes(StandardCharsets.UTF_8));
                this.output.write(": \n".getBytes(StandardCharsets.UTF_8));
                NormalizedNodeXMLOutput.toStream(this.output, data);
                this.output.writeByte(10);
            }
            catch (IOException | XMLStreamException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

