/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.spi.AbstractDOMForwardedTransaction;
import org.opendaylight.mdsal.dom.spi.AbstractDOMForwardedTransactionFactory;
import org.opendaylight.mdsal.dom.spi.TransactionCommitFailedExceptionMapper;
import org.opendaylight.mdsal.dom.spi.UncancellableListenableFuture;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DOMForwardedWriteTransaction<T extends DOMStoreWriteTransaction>
extends AbstractDOMForwardedTransaction<T>
implements DOMDataTreeWriteTransaction {
    private static final AtomicReferenceFieldUpdater<DOMForwardedWriteTransaction, AbstractDOMForwardedTransactionFactory> IMPL_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DOMForwardedWriteTransaction.class, AbstractDOMForwardedTransactionFactory.class, "commitImpl");
    private static final AtomicReferenceFieldUpdater<DOMForwardedWriteTransaction, FluentFuture> FUTURE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DOMForwardedWriteTransaction.class, FluentFuture.class, "commitFuture");
    private static final Logger LOG = LoggerFactory.getLogger(DOMForwardedWriteTransaction.class);
    private final @NonNull SettableFuture<@NonNull CommitInfo> settableCompletion = SettableFuture.create();
    private final @NonNull FluentFuture<? extends @NonNull CommitInfo> completionFuture = FluentFuture.from(new UncancellableListenableFuture<CommitInfo>((ListenableFuture<CommitInfo>)this.settableCompletion));
    private volatile AbstractDOMForwardedTransactionFactory<?> commitImpl;
    private volatile FluentFuture<?> commitFuture;

    protected DOMForwardedWriteTransaction(Object identifier, Function<LogicalDatastoreType, T> backingTxFactory, AbstractDOMForwardedTransactionFactory<?> commitImpl) {
        super(identifier, backingTxFactory);
        this.commitImpl = Objects.requireNonNull(commitImpl, "commitImpl must not be null.");
    }

    public final void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode data) {
        this.checkRunning(this.commitImpl);
        ((DOMStoreWriteTransaction)this.getSubtransaction(store)).write(path, data);
    }

    public final void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        this.checkRunning(this.commitImpl);
        ((DOMStoreWriteTransaction)this.getSubtransaction(store)).delete(path);
    }

    public final void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode data) {
        this.checkRunning(this.commitImpl);
        ((DOMStoreWriteTransaction)this.getSubtransaction(store)).merge(path, data);
    }

    public final boolean cancel() {
        FluentFuture<?> future;
        AbstractDOMForwardedTransactionFactory impl = IMPL_UPDATER.getAndSet(this, null);
        if (impl != null) {
            LOG.trace("Transaction {} cancelled before submit", this.getIdentifier());
            FUTURE_UPDATER.lazySet(this, FluentFutures.immediateCancelledFluentFuture());
            this.closeSubtransactions();
            return true;
        }
        while ((future = this.commitFuture) == null) {
        }
        return future.isCancelled();
    }

    public final FluentFuture<? extends CommitInfo> commit() {
        FluentFuture ret;
        AbstractDOMForwardedTransactionFactory impl = IMPL_UPDATER.getAndSet(this, null);
        this.checkRunning(impl);
        DOMStoreWriteTransaction tx = (DOMStoreWriteTransaction)this.getSubtransaction();
        if (tx == null) {
            ret = CommitInfo.emptyFluentFuture();
        } else {
            try {
                ret = impl.commit(this, tx.ready());
            }
            catch (RuntimeException e) {
                ret = FluentFutures.immediateFailedFluentFuture((Throwable)TransactionCommitFailedExceptionMapper.COMMIT_ERROR_MAPPER.apply(e));
            }
        }
        this.settableCompletion.setFuture((ListenableFuture)ret);
        FUTURE_UPDATER.lazySet(this, ret);
        return this.completionFuture;
    }

    public final FluentFuture<?> completionFuture() {
        return this.completionFuture;
    }

    private void checkRunning(AbstractDOMForwardedTransactionFactory<?> impl) {
        Preconditions.checkState((impl != null ? 1 : 0) != 0, (String)"Transaction %s is no longer running", (Object)this.getIdentifier());
    }
}

