/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.spi.AbstractRegistrationTree;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDOMStoreTreeChangePublisher
extends AbstractRegistrationTree<RegImpl>
implements DOMStoreTreeChangePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDOMStoreTreeChangePublisher.class);

    protected abstract void notifyListener(@NonNull Reg var1, @NonNull List<DataTreeCandidate> var2);

    protected abstract void registrationRemoved(@NonNull Reg var1);

    protected final boolean processCandidateTree(@NonNull DataTreeCandidate candidate) {
        DataTreeCandidateNode node = candidate.getRootNode();
        if (node.modificationType() == ModificationType.UNMODIFIED) {
            LOG.debug("Skipping unmodified candidate {}", (Object)candidate);
            return false;
        }
        try (AbstractRegistrationTree.Snapshot snapshot = this.takeSnapshot();){
            List<YangInstanceIdentifier.PathArgument> toLookup = List.copyOf(candidate.getRootPath().getPathArguments());
            IdentityHashMap<Reg, List<DataTreeCandidate>> listenerChanges = new IdentityHashMap<Reg, List<DataTreeCandidate>>();
            this.lookupAndNotify(toLookup, 0, snapshot.getRootNode(), candidate, listenerChanges);
            for (Map.Entry<Reg, List<DataTreeCandidate>> entry : listenerChanges.entrySet()) {
                this.notifyListener(entry.getKey(), entry.getValue());
            }
            boolean bl = !listenerChanges.isEmpty();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Registration registerTreeChangeListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener) {
        this.takeLock();
        try {
            RegImpl reg = new RegImpl(listener);
            this.addRegistration(this.findNodeFor(treeId.getPathArguments()), reg);
            RegImpl regImpl = reg;
            return regImpl;
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    @Deprecated(since="13.0.0", forRemoval=true)
    public Registration registerLegacyTreeChangeListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener) {
        return this.registerTreeChangeListener(treeId, listener);
    }

    private void lookupAndNotify(List<YangInstanceIdentifier.PathArgument> args, int offset, AbstractRegistrationTree.Node<RegImpl> node, DataTreeCandidate candidate, Map<Reg, List<DataTreeCandidate>> listenerChanges) {
        if (args.size() == offset) {
            this.notifyNode(candidate.getRootPath(), node, candidate.getRootNode(), listenerChanges);
            return;
        }
        YangInstanceIdentifier.PathArgument arg = args.get(offset);
        AbstractRegistrationTree.Node<RegImpl> exactChild = node.getExactChild(arg);
        if (exactChild != null) {
            this.lookupAndNotify(args, offset + 1, exactChild, candidate, listenerChanges);
        }
        for (AbstractRegistrationTree.Node<RegImpl> child : node.getInexactChildren(arg)) {
            this.lookupAndNotify(args, offset + 1, child, candidate, listenerChanges);
        }
    }

    private void notifyNode(YangInstanceIdentifier path, AbstractRegistrationTree.Node<RegImpl> regNode, DataTreeCandidateNode candNode, Map<Reg, List<DataTreeCandidate>> listenerChanges) {
        if (candNode.modificationType() == ModificationType.UNMODIFIED) {
            LOG.debug("Skipping unmodified candidate {}", (Object)path);
            return;
        }
        Collection<RegImpl> regs = regNode.getRegistrations();
        if (!regs.isEmpty()) {
            DataTreeCandidate dataTreeCandidate = DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)path, (DataTreeCandidateNode)candNode);
            for (RegImpl reg : regs) {
                listenerChanges.computeIfAbsent(reg, ignored -> new ArrayList()).add(dataTreeCandidate);
            }
        }
        for (DataTreeCandidateNode candChild : candNode.childNodes()) {
            if (candChild.modificationType() == ModificationType.UNMODIFIED) continue;
            AbstractRegistrationTree.Node<RegImpl> regChild = regNode.getExactChild(candChild.name());
            if (regChild != null) {
                this.notifyNode(path.node(candChild.name()), regChild, candChild, listenerChanges);
            }
            for (AbstractRegistrationTree.Node<RegImpl> rc : regNode.getInexactChildren(candChild.name())) {
                this.notifyNode(path.node(candChild.name()), rc, candChild, listenerChanges);
            }
        }
    }

    @NonNullByDefault
    protected static sealed interface Reg
    permits RegImpl {
        public DOMDataTreeChangeListener listener();

        public boolean notClosed();
    }

    @NonNullByDefault
    final class RegImpl
    extends AbstractObjectRegistration<DOMDataTreeChangeListener>
    implements Reg {
        private RegImpl(DOMDataTreeChangeListener instance) {
            super((Object)instance);
        }

        @Override
        public DOMDataTreeChangeListener listener() {
            return (DOMDataTreeChangeListener)this.getInstance();
        }

        protected void removeRegistration() {
            AbstractDOMStoreTreeChangePublisher.this.registrationRemoved(this);
        }
    }
}

