/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathMathMode;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathParser;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathParserFactory;
import org.opendaylight.yangtools.yang.xpath.impl.AntlrXPathParser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.RequireServiceComponentRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@RequireServiceComponentRuntime
public final class AntlrXPathParserFactory
implements YangXPathParserFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AntlrXPathParserFactory.class);

    public YangXPathParser newParser(YangXPathMathMode mathMode) {
        return new AntlrXPathParser.Base(mathMode);
    }

    public YangXPathParser.QualifiedBound newParser(YangXPathMathMode mathMode, YangNamespaceContext namespaceContext) {
        return new AntlrXPathParser.Qualified(mathMode, namespaceContext);
    }

    public YangXPathParser.UnqualifiedBound newParser(YangXPathMathMode mathMode, YangNamespaceContext namespaceContext, QNameModule defaultNamespace) {
        return new AntlrXPathParser.Unqualified(mathMode, namespaceContext, defaultNamespace);
    }

    @Activate
    void activate() {
        LOG.debug("XPath Parser activated");
    }

    @Deactivate
    void deactivate() {
        LOG.debug("XPath Parser deactivated");
    }
}

