/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToastType;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint32;

public class MakeToastInputBuilder {
    private Uint32 _toasterDoneness;
    private ToastType _toasterToastType;
    Map<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>> augmentation = Map.of();

    public MakeToastInputBuilder() {
    }

    public MakeToastInputBuilder(MakeToastInput base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>>(aug);
        }
        this._toasterDoneness = base.getToasterDoneness();
        this._toasterToastType = base.getToasterToastType();
    }

    public Uint32 getToasterDoneness() {
        return this._toasterDoneness;
    }

    public ToastType getToasterToastType() {
        return this._toasterToastType;
    }

    public <E$$ extends Augmentation<MakeToastInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    private static void checkToasterDonenessRange(long value) {
        if (value >= 1L && value <= 10L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..10]]", (long)value);
    }

    public MakeToastInputBuilder setToasterDoneness(Uint32 value) {
        if (value != null) {
            MakeToastInputBuilder.checkToasterDonenessRange(value.longValue());
        }
        this._toasterDoneness = value;
        return this;
    }

    public MakeToastInputBuilder setToasterToastType(ToastType value) {
        this._toasterToastType = value;
        return this;
    }

    public MakeToastInputBuilder addAugmentation(Augmentation<MakeToastInput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MakeToastInput>>, Augmentation<MakeToastInput>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MakeToastInputBuilder removeAugmentation(Class<? extends Augmentation<MakeToastInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull MakeToastInput build() {
        return new MakeToastInputImpl(this);
    }

    private static final class MakeToastInputImpl
    extends AbstractAugmentable<MakeToastInput>
    implements MakeToastInput {
        private final Uint32 _toasterDoneness;
        private final ToastType _toasterToastType;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MakeToastInputImpl(MakeToastInputBuilder base) {
            super(base.augmentation);
            this._toasterDoneness = base.getToasterDoneness();
            this._toasterToastType = base.getToasterToastType();
        }

        @Override
        public Uint32 getToasterDoneness() {
            return this._toasterDoneness;
        }

        @Override
        public ToastType getToasterToastType() {
            return this._toasterToastType;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = MakeToastInput.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return MakeToastInput.bindingEquals(this, obj);
        }

        public String toString() {
            return MakeToastInput.bindingToString(this);
        }
    }
}

