/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.spi;

import java.util.Objects;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.SourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;

public abstract class AbstractSchemaSourceCache<T extends SourceRepresentation>
implements SchemaSourceListener,
SchemaSourceProvider<T> {
    private final SchemaSourceRegistry consumer;
    private final Class<T> representation;
    private final PotentialSchemaSource.Costs cost;

    protected AbstractSchemaSourceCache(SchemaSourceRegistry consumer, Class<T> representation, PotentialSchemaSource.Costs cost) {
        this.consumer = Objects.requireNonNull(consumer);
        this.representation = Objects.requireNonNull(representation);
        this.cost = Objects.requireNonNull(cost);
    }

    protected abstract void offer(T var1);

    protected final Registration register(SourceIdentifier sourceId) {
        return this.consumer.registerSchemaSource(this, PotentialSchemaSource.create(sourceId, this.representation, this.cost.getValue()));
    }

    @Override
    public void schemaSourceEncountered(SourceRepresentation source) {
        if (this.representation.isAssignableFrom(source.getType())) {
            this.offer((SourceRepresentation)this.representation.cast(source));
        }
    }

    @Override
    public final void schemaSourceRegistered(Iterable<PotentialSchemaSource<?>> sources) {
    }

    @Override
    public final void schemaSourceUnregistered(PotentialSchemaSource<?> source) {
    }
}

