/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.BindingObject;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContext;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

abstract class AbstractBindingNormalizedNodeCache<T extends BindingObject, C extends CodecContext>
extends CacheLoader<T, NormalizedNode> {
    private final LoadingCache<T, NormalizedNode> cache;
    private final @NonNull C rootContext;

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="False positive")
    AbstractBindingNormalizedNodeCache(C rootContext) {
        this.rootContext = (CodecContext)Objects.requireNonNull(rootContext);
        this.cache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)this);
    }

    final @NonNull C rootContext() {
        return this.rootContext;
    }

    final NormalizedNode get(@NonNull T obj) {
        return (NormalizedNode)this.cache.getUnchecked(obj);
    }
}

