/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.OpaqueData;
import org.opendaylight.yangtools.binding.OpaqueObject;
import org.opendaylight.yangtools.binding.data.codec.api.BindingOpaqueObjectCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.impl.AbstractValueCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.AnydataCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.AnyxmlCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecOpaqueObject;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecPackage;
import org.opendaylight.yangtools.binding.data.codec.impl.ForeignOpaqueData;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueNodeCodecContext;
import org.opendaylight.yangtools.binding.loader.BindingClassLoader;
import org.opendaylight.yangtools.yang.data.api.schema.ForeignDataNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

abstract sealed class AbstractOpaqueCodecContext<T extends OpaqueObject<T>>
extends ValueNodeCodecContext
implements BindingOpaqueObjectCodecTreeNode<T>
permits AnydataCodecContext, AnyxmlCodecContext {
    private static final MethodType CTOR_LOOKUP_TYPE = MethodType.methodType(Void.TYPE, OpaqueData.class);
    private static final MethodType CTOR_INVOKE_TYPE = MethodType.methodType(OpaqueObject.class, OpaqueData.class);
    private static final DynamicType.Builder<CodecOpaqueObject> TEMPLATE = new ByteBuddy().subclass(CodecOpaqueObject.class).modifiers(4113);
    private final AbstractValueCodec<Object, Object> valueCodec = new AbstractValueCodec<Object, Object>(){

        @Override
        protected Object serializeImpl(Object input) {
            OpaqueObject cast;
            try {
                cast = (OpaqueObject)AbstractOpaqueCodecContext.this.getBindingClass().cast(input);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Unexpected input " + String.valueOf(input), e);
            }
            OpaqueData opaqueData = (OpaqueData)Objects.requireNonNull(cast).getValue();
            Object data = opaqueData.getData();
            if (data instanceof DOMSource) {
                DOMSource dom = (DOMSource)data;
                return dom;
            }
            throw new IllegalArgumentException("Unexpected data " + String.valueOf(data));
        }

        @Override
        protected Object deserializeImpl(Object input) {
            Preconditions.checkArgument((boolean)(input instanceof NormalizedNode), (String)"Unexpected input %s", (Object)input);
            return AbstractOpaqueCodecContext.this.deserializeObject((NormalizedNode)input);
        }
    };
    private final MethodHandle proxyConstructor;

    AbstractOpaqueCodecContext(DataSchemaNode schema, String getterName, Class<T> bindingClass, BindingClassLoader loader) {
        super(schema, getterName, bindingClass, null);
        this.proxyConstructor = AbstractOpaqueCodecContext.createImpl(loader, bindingClass);
    }

    public final Class<T> getBindingClass() {
        return this.valueType();
    }

    public final T deserialize(NormalizedNode data) {
        if (data instanceof ForeignDataNode) {
            ForeignDataNode foreign = (ForeignDataNode)data;
            return this.deserialize(foreign);
        }
        throw new IllegalArgumentException("Expected a ForeignDataNode, not " + data.contract().getSimpleName());
    }

    T deserialize(ForeignDataNode<?> foreignData) {
        return (T)((OpaqueObject)this.getBindingClass().cast(this.createBindingProxy((OpaqueData<?>)new ForeignOpaqueData(foreignData))));
    }

    public final ForeignDataNode<?> serialize(T data) {
        Object object;
        OpaqueData opaqueData = (OpaqueData)data.getValue();
        if (opaqueData instanceof ForeignOpaqueData) {
            ForeignOpaqueData foreign = (ForeignOpaqueData)opaqueData;
            object = foreign.domData();
        } else {
            object = this.serializedData(opaqueData);
        }
        return object;
    }

    @Override
    protected final @NonNull Object deserializeObject(NormalizedNode normalizedNode) {
        return this.deserialize(normalizedNode);
    }

    @Override
    ValueCodec<Object, Object> getValueCodec() {
        return this.valueCodec;
    }

    abstract @NonNull ForeignDataNode<?> serializedData(OpaqueData<?> var1);

    private OpaqueObject<?> createBindingProxy(OpaqueData<?> data) {
        try {
            return this.proxyConstructor.invokeExact(data);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private static MethodHandle createImpl(BindingClassLoader rootLoader, Class<?> bindingClass) {
        Class proxyClass = CodecPackage.CODEC.generateClass(rootLoader, bindingClass, (loader, fqcn, bindingInterface) -> BindingClassLoader.GeneratorResult.of((DynamicType.Unloaded)TEMPLATE.name(fqcn).implement(new Type[]{bindingInterface}).make()));
        try {
            return MethodHandles.publicLookup().findConstructor(proxyClass, CTOR_LOOKUP_TYPE).asType(CTOR_INVOKE_TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("Failed to access constructor for prototype " + String.valueOf(proxyClass), e);
        }
    }
}

