/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.contract.BuiltInType;
import org.opendaylight.yangtools.binding.data.codec.impl.SchemaUnawareCodec;

final class BuiltInValueCodec
extends SchemaUnawareCodec {
    private static final ImmutableMap<Class<?>, BuiltInValueCodec> SINGLETONS = (ImmutableMap)List.of(BuiltInType.INT8, BuiltInType.INT16, BuiltInType.INT32, BuiltInType.INT64, BuiltInType.UINT8, BuiltInType.UINT16, BuiltInType.UINT32, BuiltInType.UINT64, BuiltInType.DECIMAL64, BuiltInType.STRING, BuiltInType.BOOLEAN, BuiltInType.BINARY, BuiltInType.EMPTY).stream().map(BuiltInValueCodec::new).collect(ImmutableMap.toImmutableMap(codec -> codec.type.javaClass(), x -> x));
    private final @NonNull BuiltInType<?> type;

    private BuiltInValueCodec(BuiltInType<?> type) {
        this.type = Objects.requireNonNull(type);
    }

    static @Nullable BuiltInValueCodec forValueType(Class<?> valueType) {
        return (BuiltInValueCodec)SINGLETONS.get(valueType);
    }

    @Override
    Object deserializeImpl(Object product) {
        return this.type.castValue(product);
    }

    @Override
    Object serializeImpl(Object input) {
        return this.type.castValue(input);
    }
}

