/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.loader.BindingClassLoader;

enum CodecPackage {
    CODEC("org.opendaylight.yang.rt.v1.obj"),
    STREAMER("org.opendaylight.yang.rt.v1.stream"),
    EVENT_AWARE("org.opendaylight.yang.rt.v1.eia");

    private static final int PACKAGE_PREFIX_LENGTH;
    private final String packagePrefix;

    private CodecPackage(String packagePrefix) {
        this.packagePrefix = Objects.requireNonNull(packagePrefix);
    }

    <T> @NonNull Class<T> generateClass(BindingClassLoader loader, Class<?> bindingInterface, BindingClassLoader.ClassGenerator<T> generator) {
        return loader.generateClass(bindingInterface, this.createFQCN(bindingInterface), generator);
    }

    @NonNull Class<?> getGeneratedClass(BindingClassLoader loader, Class<?> bindingInterface) {
        return loader.getGeneratedClass(bindingInterface, this.createFQCN(bindingInterface));
    }

    private @NonNull String createFQCN(Class<?> bindingInterface) {
        String ifName = bindingInterface.getName();
        Preconditions.checkArgument((boolean)ifName.startsWith("org.opendaylight.yang.gen.v1"), (String)"Unrecognized interface %s", bindingInterface);
        return this.packagePrefix + ifName.substring(PACKAGE_PREFIX_LENGTH);
    }

    static {
        PACKAGE_PREFIX_LENGTH = "org.opendaylight.yang.gen.v1".length();
    }
}

