/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.ChoiceIn;
import org.opendaylight.yangtools.binding.DataContainer;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.OpaqueObject;
import org.opendaylight.yangtools.binding.data.codec.impl.ChoiceCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.ChoiceCodecPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextFactory;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextSupplier;
import org.opendaylight.yangtools.binding.data.codec.impl.CommonDataObjectCodecPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.ContainerLikeCodecPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.ListCodecPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.MapCodecPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.PropertyInfo;
import org.opendaylight.yangtools.binding.data.codec.impl.StructuralContainerCodecPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueNodeCodecContext;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.runtime.api.ChoiceRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.ContainerLikeRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.ContainerRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.GeneratedRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.ListRuntimeType;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.AddedByUsesAware;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PresenceEffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataContainerAnalysis<R extends CompositeRuntimeType> {
    private static final Logger LOG = LoggerFactory.getLogger(DataContainerAnalysis.class);
    final @NonNull ImmutableMap<Class<?>, DataContainerPrototype<?, ?>> byStreamClass;
    final @NonNull ImmutableMap<Class<?>, DataContainerPrototype<?, ?>> byBindingArgClass;
    final @NonNull ImmutableMap<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifier, CodecContextSupplier> byYang;
    final @NonNull ImmutableMap<String, ValueNodeCodecContext> leafNodes;
    final @NonNull ImmutableMap<Method, ValueNodeCodecContext> leafContexts;
    final @NonNull ImmutableMap<Class<?>, PropertyInfo> daoProperties;

    DataContainerAnalysis(CommonDataObjectCodecPrototype<R> prototype) {
        this(prototype.javaClass(), prototype.runtimeType(), prototype.contextFactory(), null);
    }

    DataContainerAnalysis(CommonDataObjectCodecPrototype<R> prototype, Class<? extends DataObject> caseClass) {
        this(prototype.javaClass(), prototype.runtimeType(), prototype.contextFactory(), Objects.requireNonNull(caseClass));
    }

    DataContainerAnalysis(Class<?> bindingClass, R runtimeType, CodecContextFactory factory, @Nullable Class<? extends DataObject> caseClass) {
        Method method;
        this.leafContexts = factory.getLeafNodes(bindingClass, runtimeType.statement());
        Map<Class<DataContainer>, Method> clsToMethod = DataContainerAnalysis.getChildrenClassToMethod(bindingClass);
        HashMap<YangInstanceIdentifier.NodeIdentifier, CodecContextSupplier> byYangBuilder = new HashMap<YangInstanceIdentifier.NodeIdentifier, CodecContextSupplier>();
        ImmutableMap.Builder leafBuilder = ImmutableMap.builderWithExpectedSize((int)this.leafContexts.size());
        for (ValueNodeCodecContext leaf : this.leafContexts.values()) {
            leafBuilder.put((Object)leaf.getSchema().getQName().getLocalName(), (Object)leaf);
            byYangBuilder.put(leaf.getDomPathArgument(), leaf);
        }
        this.leafNodes = leafBuilder.build();
        HashMap<Class<Object>, ChoiceCodecPrototype<Object>> byBindingArgClassBuilder = new HashMap<Class<Object>, ChoiceCodecPrototype<Object>>();
        HashMap byStreamClassBuilder = new HashMap();
        HashMap<Class, PropertyInfo> daoPropertiesBuilder = new HashMap<Class, PropertyInfo>();
        for (Map.Entry<Class<DataContainer>, Method> childDataObj : clsToMethod.entrySet()) {
            method = childDataObj.getValue();
            Verify.verify((!method.isDefault() ? 1 : 0) != 0, (String)"Unexpected default method %s in %s", (Object)method, bindingClass);
            Class<DataContainer> retClass = childDataObj.getKey();
            if (OpaqueObject.class.isAssignableFrom(retClass)) continue;
            daoPropertiesBuilder.put(retClass, new PropertyInfo.Getter(method));
            DataContainerPrototype<?, ?> childProto = DataContainerAnalysis.getChildPrototype(runtimeType, factory, caseClass, retClass);
            byStreamClassBuilder.put(childProto.javaClass(), childProto);
            byYangBuilder.put(childProto.yangArg(), childProto);
            if (!(childProto instanceof ChoiceCodecPrototype)) continue;
            ChoiceCodecPrototype choiceProto = (ChoiceCodecPrototype)childProto;
            for (Class<?> cazeChild : ((ChoiceCodecContext)choiceProto.getCodecContext()).getCaseChildrenClasses()) {
                byBindingArgClassBuilder.put(cazeChild, choiceProto);
            }
        }
        this.byStreamClass = ImmutableMap.copyOf(byStreamClassBuilder);
        byBindingArgClassBuilder.putAll(byStreamClassBuilder);
        this.byBindingArgClass = byStreamClassBuilder.equals(byBindingArgClassBuilder) ? this.byStreamClass : ImmutableMap.copyOf(byBindingArgClassBuilder);
        for (Map.Entry<Class<DataContainer>, Method> entry : DataContainerAnalysis.getChildrenClassToNonnullMethod(bindingClass).entrySet()) {
            method = entry.getValue();
            if (method.isDefault()) continue;
            daoPropertiesBuilder.compute(entry.getKey(), (key, value) -> new PropertyInfo.GetterAndNonnull(((PropertyInfo)Verify.verifyNotNull((Object)value, (String)"No getter for %s", (Object[])new Object[]{key})).getterMethod(), method));
        }
        this.byYang = ImmutableMap.copyOf(byYangBuilder);
        this.daoProperties = ImmutableMap.copyOf(daoPropertiesBuilder);
    }

    private static @NonNull DataContainerPrototype<?, ?> getChildPrototype(CompositeRuntimeType type, CodecContextFactory factory, @Nullable Class<? extends DataObject> caseClass, Class<? extends DataContainer> childClass) {
        GeneratedRuntimeType child = type.bindingChild(JavaTypeName.create(childClass));
        if (child == null) {
            throw DataContainerCodecContext.childNullException(factory.runtimeContext(), childClass, "Node %s does not have child named %s", type, childClass);
        }
        if (child instanceof ChoiceRuntimeType) {
            ChoiceRuntimeType choice = (ChoiceRuntimeType)child;
            return new ChoiceCodecPrototype<ChoiceIn>(factory, choice, childClass.asSubclass(ChoiceIn.class));
        }
        DataObjectStep<? extends DataContainer> item = DataContainerAnalysis.createItem(caseClass, childClass, child.statement());
        if (child instanceof ContainerLikeRuntimeType) {
            ContainerRuntimeType container;
            ContainerLikeRuntimeType containerLike = (ContainerLikeRuntimeType)child;
            if (child instanceof ContainerRuntimeType && ((ContainerEffectiveStatement)(container = (ContainerRuntimeType)child).statement()).findFirstEffectiveSubstatement(PresenceEffectiveStatement.class).isEmpty()) {
                return new StructuralContainerCodecPrototype(item, container, factory);
            }
            return new ContainerLikeCodecPrototype(item, containerLike, factory);
        }
        if (child instanceof ListRuntimeType) {
            ListRuntimeType list = (ListRuntimeType)child;
            return list.keyType() != null ? new MapCodecPrototype(item, list, factory) : new ListCodecPrototype(item, list, factory);
        }
        throw new UnsupportedOperationException("Unhandled type " + String.valueOf(child));
    }

    private static @NonNull DataObjectStep<?> createItem(@Nullable Class<? extends DataObject> caseClass, Class<?> childClass, EffectiveStatement<?, ?> childSchema) {
        AddedByUsesAware aware;
        return caseClass != null && childSchema instanceof AddedByUsesAware && (aware = (AddedByUsesAware)childSchema).isAddedByUses() ? DataObjectStep.of(caseClass, childClass) : DataObjectStep.of(childClass);
    }

    private static Map<Class<? extends DataContainer>, Method> getChildrenClassToMethod(Class<?> type) {
        return DataContainerAnalysis.getChildClassToMethod(type, "get");
    }

    private static Map<Class<? extends DataContainer>, Method> getChildrenClassToNonnullMethod(Class<?> type) {
        return DataContainerAnalysis.getChildClassToMethod(type, "nonnull");
    }

    private static Map<Class<? extends DataContainer>, Method> getChildClassToMethod(Class<?> type, String prefix) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Target type must not be null");
        Preconditions.checkArgument((boolean)DataContainer.class.isAssignableFrom(type), (String)"Supplied type %s must be derived from DataContainer", type);
        HashMap<Class<? extends DataContainer>, Method> ret = new HashMap<Class<? extends DataContainer>, Method>();
        for (Method method : type.getMethods()) {
            DataContainerAnalysis.getYangModeledReturnType(method, prefix).ifPresent(entity -> ret.put((Class<? extends DataContainer>)entity, method));
        }
        return ret;
    }

    static Optional<Class<? extends DataContainer>> getYangModeledReturnType(Method method, String prefix) {
        String methodName = method.getName();
        if ("getClass".equals(methodName) || !methodName.startsWith(prefix) || method.getParameterCount() > 0) {
            return Optional.empty();
        }
        Class<?> returnType = method.getReturnType();
        if (DataContainer.class.isAssignableFrom(returnType)) {
            return DataContainerAnalysis.optionalDataContainer(returnType);
        }
        if (List.class.isAssignableFrom(returnType)) {
            return DataContainerAnalysis.getYangModeledReturnType(method, 0);
        }
        if (Map.class.isAssignableFrom(returnType)) {
            return DataContainerAnalysis.getYangModeledReturnType(method, 1);
        }
        return Optional.empty();
    }

    private static Optional<Class<? extends DataContainer>> getYangModeledReturnType(Method method, int parameterOffset) {
        try {
            return (Optional)ClassLoaderUtils.callWithClassLoader((ClassLoader)method.getDeclaringClass().getClassLoader(), () -> DataContainerAnalysis.genericParameter(method.getGenericReturnType(), parameterOffset).flatMap(result -> result instanceof Class ? DataContainerAnalysis.optionalCast((Class)result) : Optional.empty()));
        }
        catch (Exception e) {
            LOG.debug("Unable to find YANG modeled return type for {}", (Object)method, (Object)e);
            return Optional.empty();
        }
    }

    private static Optional<Type> genericParameter(Type type, int offset) {
        ParameterizedType parameterized;
        Type[] parameters;
        if (type instanceof ParameterizedType && (parameters = (parameterized = (ParameterizedType)type).getActualTypeArguments()).length > offset) {
            return Optional.of(parameters[offset]);
        }
        return Optional.empty();
    }

    private static Optional<Class<? extends DataContainer>> optionalCast(Class<?> type) {
        return DataContainer.class.isAssignableFrom(type) ? DataContainerAnalysis.optionalDataContainer(type) : Optional.empty();
    }

    private static Optional<Class<? extends DataContainer>> optionalDataContainer(Class<?> type) {
        return Optional.of(type.asSubclass(DataContainer.class));
    }
}

