/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.Augmentable;
import org.opendaylight.yangtools.binding.DataContainer;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.KeyAware;
import org.opendaylight.yangtools.binding.data.codec.api.BindingStreamEventWriter;
import org.opendaylight.yangtools.binding.data.codec.impl.ByteBuddyUtils;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextFactory;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecPackage;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerSerializerRegistry;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerStreamer;
import org.opendaylight.yangtools.binding.data.codec.spi.BindingSchemaMapping;
import org.opendaylight.yangtools.binding.loader.BindingClassLoader;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataContainerStreamerGenerator<T extends DataContainerStreamer<?>>
implements BindingClassLoader.ClassGenerator<T> {
    static final String INSTANCE_FIELD = "INSTANCE";
    private static final Logger LOG = LoggerFactory.getLogger(DataContainerStreamerGenerator.class);
    private static final TypeDescription.Generic BB_VOID = TypeDefinition.Sort.describe(Void.TYPE);
    private static final TypeDescription.Generic BB_DATA_CONTAINER = TypeDefinition.Sort.describe(DataContainer.class);
    private static final TypeDescription.Generic BB_DOSR = TypeDefinition.Sort.describe(DataContainerSerializerRegistry.class);
    private static final TypeDescription.Generic BB_BESV = TypeDefinition.Sort.describe(BindingStreamEventWriter.class);
    private static final TypeDescription.Generic BB_IOX = TypeDefinition.Sort.describe(IOException.class);
    private static final DynamicType.Builder<?> TEMPLATE = new ByteBuddy().subclass(DataContainerStreamer.class).modifiers(4113);
    private static final StackManipulation REG = MethodVariableAccess.REFERENCE.loadFrom(1);
    private static final StackManipulation OBJ = MethodVariableAccess.REFERENCE.loadFrom(2);
    private static final StackManipulation STREAM = MethodVariableAccess.REFERENCE.loadFrom(3);
    private static final StackManipulation UNKNOWN_SIZE = IntegerConstant.forValue((int)-1);
    private static final StackManipulation START_AUGMENTATION_NODE = ByteBuddyUtils.invokeMethod(BindingStreamEventWriter.class, "startAugmentationNode", Class.class);
    private static final StackManipulation START_CASE = ByteBuddyUtils.invokeMethod(BindingStreamEventWriter.class, "startCase", Class.class, Integer.TYPE);
    private static final StackManipulation START_CONTAINER_NODE = ByteBuddyUtils.invokeMethod(BindingStreamEventWriter.class, "startContainerNode", Class.class, Integer.TYPE);
    private static final StackManipulation END_NODE = ByteBuddyUtils.invokeMethod(BindingStreamEventWriter.class, "endNode", new Class[0]);
    private static final StackManipulation START_MAP_ENTRY_NODE = new StackManipulation.Compound(new StackManipulation[]{OBJ, ByteBuddyUtils.invokeMethod(KeyAware.class, "key", new Class[0]), UNKNOWN_SIZE, ByteBuddyUtils.invokeMethod(BindingStreamEventWriter.class, "startMapEntryNode", Key.class, Integer.TYPE)});
    private static final StackManipulation START_UNKEYED_LIST_ITEM = new StackManipulation.Compound(new StackManipulation[]{UNKNOWN_SIZE, ByteBuddyUtils.invokeMethod(BindingStreamEventWriter.class, "startUnkeyedListItem", Integer.TYPE)});
    private static final StackManipulation STREAM_ANYDATA = ByteBuddyUtils.invokeMethod(DataContainerStreamer.class, "streamAnydata", BindingStreamEventWriter.class, String.class, Object.class);
    private static final StackManipulation STREAM_ANYXML = ByteBuddyUtils.invokeMethod(DataContainerStreamer.class, "streamAnyxml", BindingStreamEventWriter.class, String.class, Object.class);
    private static final StackManipulation STREAM_CHOICE = ByteBuddyUtils.invokeMethod(DataContainerStreamer.class, "streamChoice", Class.class, DataContainerSerializerRegistry.class, BindingStreamEventWriter.class, DataContainer.class);
    private static final StackManipulation STREAM_CONTAINER = ByteBuddyUtils.invokeMethod(DataContainerStreamer.class, "streamContainer", DataContainerStreamer.class, DataContainerSerializerRegistry.class, BindingStreamEventWriter.class, DataObject.class);
    private static final StackManipulation STREAM_LEAF = ByteBuddyUtils.invokeMethod(DataContainerStreamer.class, "streamLeaf", BindingStreamEventWriter.class, String.class, Object.class);
    private static final StackManipulation STREAM_LEAF_LIST = ByteBuddyUtils.invokeMethod(DataContainerStreamer.class, "streamLeafList", BindingStreamEventWriter.class, String.class, Set.class);
    private static final StackManipulation STREAM_ORDERED_LEAF_LIST = ByteBuddyUtils.invokeMethod(DataContainerStreamer.class, "streamOrderedLeafList", BindingStreamEventWriter.class, String.class, List.class);
    private static final StackManipulation STREAM_LIST = ByteBuddyUtils.invokeMethod(DataContainerStreamer.class, "streamList", Class.class, DataContainerStreamer.class, DataContainerSerializerRegistry.class, BindingStreamEventWriter.class, List.class);
    private static final StackManipulation STREAM_MAP = ByteBuddyUtils.invokeMethod(DataContainerStreamer.class, "streamMap", Class.class, DataContainerStreamer.class, DataContainerSerializerRegistry.class, BindingStreamEventWriter.class, Map.class);
    private static final StackManipulation STREAM_ORDERED_MAP = ByteBuddyUtils.invokeMethod(DataContainerStreamer.class, "streamOrderedMap", Class.class, DataContainerStreamer.class, DataContainerSerializerRegistry.class, BindingStreamEventWriter.class, List.class);
    private static final StackManipulation STREAM_AUGMENTATIONS = new StackManipulation.Compound(new StackManipulation[]{REG, STREAM, OBJ, ByteBuddyUtils.invokeMethod(DataContainerStreamer.class, "streamAugmentations", DataContainerSerializerRegistry.class, BindingStreamEventWriter.class, Augmentable.class)});
    private final CodecContextFactory registry;
    private final StackManipulation startEvent;
    private final DataNodeContainer schema;
    private final Class<?> type;
    private final GeneratedType genType;

    private DataContainerStreamerGenerator(CodecContextFactory registry, GeneratedType genType, DataNodeContainer schema, Class<?> type, StackManipulation startEvent) {
        this.registry = Objects.requireNonNull(registry);
        this.genType = Objects.requireNonNull(genType);
        this.schema = Objects.requireNonNull(schema);
        this.type = Objects.requireNonNull(type);
        this.startEvent = Objects.requireNonNull(startEvent);
    }

    static Class<? extends DataContainerStreamer<?>> generateStreamer(BindingClassLoader loader, CodecContextFactory registry, Class<?> type) {
        StackManipulation startEvent;
        RuntimeType typeAndSchema = registry.runtimeContext().getTypeWithSchema(type);
        EffectiveStatement schema = typeAndSchema.statement();
        if (schema instanceof ContainerLike || schema instanceof NotificationDefinition) {
            startEvent = DataContainerStreamerGenerator.classUnknownSizeMethod(START_CONTAINER_NODE, type);
        } else if (schema instanceof ListSchemaNode) {
            ListSchemaNode listSchema = (ListSchemaNode)schema;
            startEvent = listSchema.getKeyDefinition().isEmpty() ? START_UNKEYED_LIST_ITEM : START_MAP_ENTRY_NODE;
        } else if (schema instanceof AugmentationSchemaNode) {
            startEvent = new StackManipulation.Compound(new StackManipulation[]{ClassConstant.of((TypeDescription)TypeDefinition.Sort.describe(type).asErasure()), START_AUGMENTATION_NODE});
        } else if (schema instanceof CaseSchemaNode) {
            startEvent = DataContainerStreamerGenerator.classUnknownSizeMethod(START_CASE, type);
        } else {
            throw new UnsupportedOperationException("Schema type " + String.valueOf(schema.getClass()) + " is not supported");
        }
        return CodecPackage.STREAMER.generateClass(loader, type, new DataContainerStreamerGenerator(registry, (GeneratedType)typeAndSchema.javaType(), (DataNodeContainer)schema, type, startEvent));
    }

    public BindingClassLoader.GeneratorResult<T> generateClass(BindingClassLoader loader, String fqcn, Class<?> bindingInterface) {
        LOG.trace("Definining streamer {}", (Object)fqcn);
        DynamicType.Builder builder = TEMPLATE.name(fqcn);
        ImmutableMap<String, Type> props = DataContainerStreamerGenerator.collectAllProperties(this.genType);
        ArrayList<ChildStream> children = new ArrayList<ChildStream>(props.size());
        for (Object schemaChild : this.schema.getChildNodes()) {
            Method getter;
            if (schemaChild.isAugmenting()) continue;
            String getterName = BindingSchemaMapping.getGetterMethodName((DataSchemaNode)schemaChild);
            try {
                getter = this.type.getMethod(getterName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Failed to find getter " + getterName, e);
            }
            ChildStream child = this.createStream(loader, props, (DataSchemaNode)schemaChild, getter);
            if (child == null) continue;
            children.add(child);
        }
        ImmutableList.Builder depBuilder = ImmutableList.builder();
        for (ChildStream child : children) {
            Class<?> dependency = child.getDependency();
            if (dependency == null) continue;
            depBuilder.add(dependency);
        }
        BindingClassLoader.GeneratorResult result = BindingClassLoader.GeneratorResult.of((DynamicType.Unloaded)builder.defineMethod("serialize", (TypeDefinition)BB_VOID, 4116).withParameters(new TypeDefinition[]{BB_DOSR, BB_DATA_CONTAINER, BB_BESV}).throwing(new TypeDefinition[]{BB_IOX}).intercept((Implementation)new SerializeImplementation(bindingInterface, this.startEvent, children)).make(), (Collection)depBuilder.build());
        LOG.trace("Definition of {} done", (Object)fqcn);
        return result;
    }

    private ChildStream createStream(BindingClassLoader loader, ImmutableMap<String, Type> props, DataSchemaNode childSchema, Method getter) {
        if (childSchema instanceof LeafSchemaNode) {
            return DataContainerStreamerGenerator.qnameChildStream(STREAM_LEAF, getter, childSchema);
        }
        if (childSchema instanceof ContainerSchemaNode) {
            return this.containerChildStream(getter);
        }
        if (childSchema instanceof ListSchemaNode) {
            Class<?> valueClass;
            ListSchemaNode listSchema = (ListSchemaNode)childSchema;
            String getterName = getter.getName();
            Type childType = (Type)props.get((Object)getterName);
            Verify.verify((boolean)(childType instanceof ParameterizedType), (String)"Unexpected type %s for %s", (Object)childType, (Object)getterName);
            Type[] params = ((ParameterizedType)childType).getActualTypeArguments();
            if (!listSchema.isUserOrdered() && !listSchema.getKeyDefinition().isEmpty()) {
                DataContainerStreamerGenerator.loadTypeClass(loader, params[0]);
                valueClass = DataContainerStreamerGenerator.loadTypeClass(loader, params[1]);
            } else {
                valueClass = DataContainerStreamerGenerator.loadTypeClass(loader, params[0]);
            }
            return this.listChildStream(getter, valueClass.asSubclass(DataObject.class), listSchema);
        }
        if (childSchema instanceof ChoiceSchemaNode) {
            return DataContainerStreamerGenerator.choiceChildStream(getter);
        }
        if (childSchema instanceof AnydataSchemaNode) {
            return DataContainerStreamerGenerator.qnameChildStream(STREAM_ANYDATA, getter, childSchema);
        }
        if (childSchema instanceof AnyxmlSchemaNode) {
            return DataContainerStreamerGenerator.qnameChildStream(STREAM_ANYXML, getter, childSchema);
        }
        if (childSchema instanceof LeafListSchemaNode) {
            LeafListSchemaNode leafListSchema = (LeafListSchemaNode)childSchema;
            return DataContainerStreamerGenerator.qnameChildStream(leafListSchema.isUserOrdered() ? STREAM_ORDERED_LEAF_LIST : STREAM_LEAF_LIST, getter, childSchema);
        }
        LOG.debug("Ignoring {} due to unhandled schema {}", (Object)getter, (Object)childSchema);
        return null;
    }

    private static ChildStream choiceChildStream(Method getter) {
        return new ChildStream(ClassConstant.of((TypeDescription)TypeDefinition.Sort.describe(getter.getReturnType()).asErasure()), REG, STREAM, OBJ, ByteBuddyUtils.invokeMethod(getter), STREAM_CHOICE);
    }

    private ChildStream containerChildStream(Method getter) {
        Class<DataObject> itemClass = getter.getReturnType().asSubclass(DataObject.class);
        DataContainerStreamer<?> streamer = this.registry.getDataContainerStreamer(itemClass);
        return new ChildStream(streamer, DataContainerStreamerGenerator.streamerInstance(streamer), REG, STREAM, OBJ, ByteBuddyUtils.invokeMethod(getter), STREAM_CONTAINER);
    }

    private ChildStream listChildStream(Method getter, Class<? extends DataObject> itemClass, ListSchemaNode childSchema) {
        DataContainerStreamer<?> streamer = this.registry.getDataContainerStreamer(itemClass);
        StackManipulation method = childSchema.getKeyDefinition().isEmpty() ? STREAM_LIST : (childSchema.isUserOrdered() ? STREAM_ORDERED_MAP : STREAM_MAP);
        return new ChildStream(streamer, ClassConstant.of((TypeDescription)TypeDefinition.Sort.describe(itemClass).asErasure()), DataContainerStreamerGenerator.streamerInstance(streamer), REG, STREAM, OBJ, ByteBuddyUtils.invokeMethod(getter), method);
    }

    private static ChildStream qnameChildStream(StackManipulation method, Method getter, DataSchemaNode schema) {
        return new ChildStream(new StackManipulation[]{STREAM, new TextConstant(schema.getQName().getLocalName()), OBJ, ByteBuddyUtils.invokeMethod(getter), method});
    }

    private static StackManipulation streamerInstance(DataContainerStreamer<?> streamer) {
        try {
            return ByteBuddyUtils.getField(streamer.getClass().getDeclaredField(INSTANCE_FIELD));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private static StackManipulation classUnknownSizeMethod(StackManipulation method, Class<?> type) {
        return new StackManipulation.Compound(new StackManipulation[]{ClassConstant.of((TypeDescription)TypeDefinition.Sort.describe(type).asErasure()), UNKNOWN_SIZE, method});
    }

    private static ImmutableMap<String, Type> collectAllProperties(GeneratedType type) {
        HashMap<String, Type> props = new HashMap<String, Type>();
        DataContainerStreamerGenerator.collectAllProperties(type, props);
        return ImmutableMap.copyOf(props);
    }

    private static void collectAllProperties(GeneratedType type, Map<String, Type> hashMap) {
        for (MethodSignature definition : type.getMethodDefinitions()) {
            hashMap.put(definition.getName(), definition.getReturnType());
        }
        for (Type parent : type.getImplements()) {
            if (!(parent instanceof GeneratedType)) continue;
            GeneratedType generated = (GeneratedType)parent;
            DataContainerStreamerGenerator.collectAllProperties(generated, hashMap);
        }
    }

    private static Class<?> loadTypeClass(BindingClassLoader loader, Type type) {
        try {
            return loader.loadClass(type.getFullyQualifiedName());
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError("Failed to load " + String.valueOf(type), e);
        }
    }

    private static final class ChildStream
    extends StackManipulation.Compound {
        private final @Nullable Class<?> dependency;

        ChildStream(StackManipulation ... stackManipulation) {
            super(stackManipulation);
            this.dependency = null;
        }

        ChildStream(DataContainerStreamer<?> streamer, StackManipulation ... stackManipulation) {
            super(stackManipulation);
            this.dependency = streamer.getClass();
        }

        @Nullable Class<?> getDependency() {
            return this.dependency;
        }
    }

    private static final class SerializeImplementation
    implements Implementation {
        private final List<ChildStream> children;
        private final StackManipulation startEvent;
        private final Class<?> bindingInterface;

        SerializeImplementation(Class<?> bindingInterface, StackManipulation startEvent, List<ChildStream> children) {
            this.bindingInterface = Objects.requireNonNull(bindingInterface);
            this.startEvent = Objects.requireNonNull(startEvent);
            this.children = Objects.requireNonNull(children);
        }

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(new FieldDescription.Token(DataContainerStreamerGenerator.INSTANCE_FIELD, 4121, instrumentedType.asGenericType())).withInitializer((ByteCodeAppender)InitializeInstanceField.INSTANCE);
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            ArrayList<Object> manipulations = new ArrayList<Object>(this.children.size() + 6);
            manipulations.add(STREAM);
            manipulations.add(this.startEvent);
            manipulations.addAll(this.children);
            if (Augmentable.class.isAssignableFrom(this.bindingInterface)) {
                manipulations.add(STREAM_AUGMENTATIONS);
            }
            manipulations.add(STREAM);
            manipulations.add(END_NODE);
            manipulations.add(MethodReturn.VOID);
            return new ByteCodeAppender.Simple(manipulations);
        }
    }

    private static enum InitializeInstanceField implements ByteCodeAppender
    {
        INSTANCE;

        private static final ElementMatcher<MethodDescription> IS_DEFAULT_CONSTRUCTOR;

        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            TypeDescription instrumentedType = implementationContext.getInstrumentedType();
            StackManipulation.Size operandStackSize = new StackManipulation.Compound(new StackManipulation[]{TypeCreation.of((TypeDescription)instrumentedType), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodDescription.InDefinedShape)((MethodList)instrumentedType.getDeclaredMethods().filter(IS_DEFAULT_CONSTRUCTOR)).getOnly()).asDefined())), ByteBuddyUtils.putField(instrumentedType, DataContainerStreamerGenerator.INSTANCE_FIELD)}).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(operandStackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        static {
            IS_DEFAULT_CONSTRUCTOR = ElementMatchers.isDefaultConstructor();
        }
    }
}

