/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextSupplier;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerPrototype;

abstract sealed class LazyCodecContextSupplier<C extends CodecContext>
implements CodecContextSupplier
permits DataContainerPrototype {
    private static final VarHandle INSTANCE;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile C instance;

    LazyCodecContextSupplier() {
    }

    public final C getCodecContext() {
        CodecContext existing = INSTANCE.getAcquire(this);
        return (C)(existing != null ? existing : this.loadInstance());
    }

    private @NonNull C loadInstance() {
        C tmp = this.createInstance();
        CodecContext witness = INSTANCE.compareAndExchangeRelease(this, null, (CodecContext)tmp);
        return (C)(witness == null ? tmp : witness);
    }

    abstract @NonNull C createInstance();

    static {
        try {
            INSTANCE = MethodHandles.lookup().findVarHandle(LazyCodecContextSupplier.class, "instance", CodecContext.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

