/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.function.IntFunction;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueNodeCodecContext;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;

final class LeafSetNodeCodecContext
extends ValueNodeCodecContext.WithCodec {
    private final IntFunction<ImmutableCollection.Builder<Object>> builderFactory;

    LeafSetNodeCodecContext(LeafListSchemaNode schema, ValueCodec<Object, Object> codec, String getterName, Class<?> valueType) {
        super((DataSchemaNode)schema, codec, getterName, valueType, null);
        this.builderFactory = schema.isUserOrdered() ? ImmutableList::builderWithExpectedSize : ImmutableSet::builderWithExpectedSize;
    }

    protected ImmutableCollection<?> deserializeObject(NormalizedNode normalizedNode) {
        if (normalizedNode instanceof LeafSetNode) {
            Collection domValues = ((LeafSetNode)normalizedNode).body();
            ValueCodec<Object, Object> codec = this.getValueCodec();
            ImmutableCollection.Builder<Object> builder = this.builderFactory.apply(domValues.size());
            for (LeafSetEntryNode valueNode : domValues) {
                builder.add(codec.deserialize(valueNode.body()));
            }
            return builder.build();
        }
        return null;
    }
}

