/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node.impl;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.spi.node.impl.ImmutableUnkeyedListNode;

public final class ImmutableUnkeyedListNodeBuilder
implements UnkeyedListNode.Builder {
    private List<UnkeyedListEntryNode> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;
    private boolean dirty;

    public ImmutableUnkeyedListNodeBuilder() {
        this.value = new LinkedList<UnkeyedListEntryNode>();
        this.dirty = false;
    }

    public ImmutableUnkeyedListNodeBuilder(int sizeHint) {
        this();
    }

    protected ImmutableUnkeyedListNodeBuilder(ImmutableUnkeyedListNode node) {
        this.nodeIdentifier = node.name();
        this.value = new LinkedList<UnkeyedListEntryNode>();
        Iterables.addAll(this.value, (Iterable)((Iterable)node.body()));
        this.dirty = true;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull UnkeyedListNode.Builder create(UnkeyedListNode node) {
        if (node instanceof ImmutableUnkeyedListNode) {
            ImmutableUnkeyedListNode immutableNode = (ImmutableUnkeyedListNode)node;
            return new ImmutableUnkeyedListNodeBuilder(immutableNode);
        }
        throw new UnsupportedOperationException("Cannot initialize from class " + String.valueOf(node.getClass()));
    }

    private void checkDirty() {
        if (this.dirty) {
            this.value = new LinkedList<UnkeyedListEntryNode>(this.value);
            this.dirty = false;
        }
    }

    public ImmutableUnkeyedListNodeBuilder withChild(UnkeyedListEntryNode child) {
        this.checkDirty();
        this.value.add(child);
        return this;
    }

    public ImmutableUnkeyedListNodeBuilder withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.checkDirty();
        throw new UnsupportedOperationException("Children does not have identifiers.");
    }

    public ImmutableUnkeyedListNodeBuilder withValue(Collection<UnkeyedListEntryNode> withValue) {
        for (UnkeyedListEntryNode node : withValue) {
            this.withChild(node);
        }
        return this;
    }

    public ImmutableUnkeyedListNodeBuilder withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    public UnkeyedListNode build() {
        this.dirty = true;
        return ImmutableUnkeyedListNode.of(this.nodeIdentifier, this.value);
    }

    public ImmutableUnkeyedListNodeBuilder addChild(UnkeyedListEntryNode child) {
        return this.withChild(child);
    }

    public ImmutableUnkeyedListNodeBuilder removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }
}

