/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserLeafSetNode;
import org.opendaylight.yangtools.yang.data.spi.node.impl.ImmutableLeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.spi.node.impl.ImmutableUserLeafSetNode;

public final class ImmutableUserLeafSetNodeBuilder<T>
implements UserLeafSetNode.Builder<T> {
    private Map<YangInstanceIdentifier.NodeWithValue<T>, LeafSetEntryNode<T>> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;
    private boolean dirty;

    public ImmutableUserLeafSetNodeBuilder() {
        this.value = new LinkedHashMap<YangInstanceIdentifier.NodeWithValue<T>, LeafSetEntryNode<T>>();
        this.dirty = false;
    }

    public ImmutableUserLeafSetNodeBuilder(int sizeHint) {
        this.value = LinkedHashMap.newLinkedHashMap(sizeHint);
        this.dirty = false;
    }

    ImmutableUserLeafSetNodeBuilder(ImmutableUserLeafSetNode<T> node) {
        this.nodeIdentifier = node.name();
        this.value = Collections.unmodifiableMap(node.children);
        this.dirty = true;
    }

    public static <T> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull UserLeafSetNode.Builder<T> create(UserLeafSetNode<T> node) {
        if (node instanceof ImmutableUserLeafSetNode) {
            ImmutableUserLeafSetNode immutable = (ImmutableUserLeafSetNode)node;
            return new ImmutableUserLeafSetNodeBuilder<T>(immutable);
        }
        throw new UnsupportedOperationException("Cannot initialize from class " + String.valueOf(node.getClass()));
    }

    private void checkDirty() {
        if (this.dirty) {
            this.value = new LinkedHashMap<YangInstanceIdentifier.NodeWithValue<T>, LeafSetEntryNode<T>>(this.value);
            this.dirty = false;
        }
    }

    public ImmutableUserLeafSetNodeBuilder<T> withChild(LeafSetEntryNode<T> child) {
        this.checkDirty();
        this.value.put(child.name(), child);
        return this;
    }

    public ImmutableUserLeafSetNodeBuilder<T> withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.checkDirty();
        this.value.remove(key);
        return this;
    }

    public UserLeafSetNode<T> build() {
        this.dirty = true;
        return new ImmutableUserLeafSetNode<T>(this.nodeIdentifier, this.value);
    }

    public ImmutableUserLeafSetNodeBuilder<T> withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    public ImmutableUserLeafSetNodeBuilder<T> withValue(Collection<LeafSetEntryNode<T>> withValue) {
        this.checkDirty();
        for (LeafSetEntryNode<T> leafSetEntry : withValue) {
            this.withChild(leafSetEntry);
        }
        return this;
    }

    public ImmutableUserLeafSetNodeBuilder<T> withChildValue(T childValue) {
        return this.withChild((LeafSetEntryNode<T>)ImmutableLeafSetEntryNode.of(new YangInstanceIdentifier.NodeWithValue(this.nodeIdentifier.getNodeType(), childValue)));
    }

    public ImmutableUserLeafSetNodeBuilder<T> addChild(LeafSetEntryNode<T> child) {
        return this.withChild(child);
    }

    public ImmutableUserLeafSetNodeBuilder<T> removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }
}

