/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.core.general.entity.rev150930;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.core.general.entity.rev150930.Entity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.core.general.entity.rev150930.EntityKey;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;

public class EntityBuilder {
    private String _name;
    private EntityKey key;
    Map<Class<? extends Augmentation<Entity>>, Augmentation<Entity>> augmentation = Map.of();

    public EntityBuilder() {
    }

    public EntityBuilder(Entity base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
    }

    public EntityKey key() {
        return this.key;
    }

    public String getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<Entity>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public EntityBuilder withKey(EntityKey key) {
        this.key = key;
        return this;
    }

    public EntityBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public EntityBuilder addAugmentation(Augmentation<Entity> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public EntityBuilder removeAugmentation(Class<? extends Augmentation<Entity>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Entity build() {
        return new EntityImpl(this);
    }

    private static final class EntityImpl
    extends AbstractEntryObject<Entity, EntityKey>
    implements Entity {
        private final String _name;
        private int hash = 0;
        private volatile boolean hashValid = false;

        EntityImpl(EntityBuilder base) {
            super(base.augmentation, (Key)EntityImpl.extractKey(base));
            EntityKey key = (EntityKey)this.key();
            this._name = key.getName();
        }

        private static @NonNull EntityKey extractKey(EntityBuilder base) {
            EntityKey key = base.key();
            return key != null ? key : new EntityKey(base.getName());
        }

        @Override
        public String getName() {
            return this._name;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Entity.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Entity.bindingEquals(this, obj);
        }

        public String toString() {
            return Entity.bindingToString(this);
        }
    }
}

