/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.collect.MutableClassToInstanceMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMMountPointListener;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.mdsal.dom.spi.SimpleDOMMountPoint;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.ObjectRegistry;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component
public final class DOMMountPointServiceImpl
implements DOMMountPointService {
    private static final Logger LOG = LoggerFactory.getLogger(DOMMountPointServiceImpl.class);
    private final Map<YangInstanceIdentifier, DOMMountPoint> mountPoints = new HashMap<YangInstanceIdentifier, DOMMountPoint>();
    private final ObjectRegistry<DOMMountPointListener> listeners = ObjectRegistry.createConcurrent((String)"mount point listeners");

    @Inject
    @Activate
    public DOMMountPointServiceImpl() {
    }

    public Optional<DOMMountPoint> getMountPoint(YangInstanceIdentifier path) {
        return Optional.ofNullable(this.mountPoints.get(path));
    }

    public synchronized DOMMountPointService.DOMMountPointBuilder createMountPoint(YangInstanceIdentifier path) {
        DOMMountPointServiceImpl.checkNotExists(path, this.mountPoints.get(Objects.requireNonNull(path)));
        return new DOMMountPointBuilderImpl(path);
    }

    public Registration registerProvisionListener(DOMMountPointListener listener) {
        return this.listeners.register((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectRegistration<DOMMountPoint> registerMountPoint(SimpleDOMMountPoint mountPoint) {
        YangInstanceIdentifier mountPointId = mountPoint.getIdentifier();
        Map<YangInstanceIdentifier, DOMMountPoint> map = this.mountPoints;
        synchronized (map) {
            DOMMountPointServiceImpl.checkNotExists(mountPointId, this.mountPoints.putIfAbsent(mountPointId, (DOMMountPoint)mountPoint));
        }
        this.listeners.streamObjects().forEach(listener -> {
            try {
                listener.onMountPointCreated((DOMMountPoint)mountPoint);
            }
            catch (Exception ex) {
                LOG.error("Listener {} failed on mount point {} created event", new Object[]{listener, mountPoint, ex});
            }
        });
        return new AbstractObjectRegistration<DOMMountPoint>((DOMMountPoint)mountPoint){

            protected void removeRegistration() {
                DOMMountPointServiceImpl.this.unregisterMountPoint((YangInstanceIdentifier)((DOMMountPoint)this.getInstance()).getIdentifier());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterMountPoint(YangInstanceIdentifier mountPointId) {
        Map<YangInstanceIdentifier, DOMMountPoint> map = this.mountPoints;
        synchronized (map) {
            if (this.mountPoints.remove(mountPointId) == null) {
                LOG.warn("Removing non-existent mount point {} at", (Object)mountPointId, (Object)new Throwable());
                return;
            }
        }
        this.listeners.streamObjects().forEach(listener -> {
            try {
                listener.onMountPointRemoved(mountPointId);
            }
            catch (Exception ex) {
                LOG.error("Listener {} failed on mount point {} removed event", new Object[]{listener, mountPointId, ex});
            }
        });
    }

    private static void checkNotExists(YangInstanceIdentifier id, DOMMountPoint mountPoint) {
        if (mountPoint != null) {
            throw new IllegalStateException("Mount point " + String.valueOf(id) + " already exists as " + String.valueOf(mountPoint));
        }
    }

    private final class DOMMountPointBuilderImpl
    implements DOMMountPointService.DOMMountPointBuilder {
        private final MutableClassToInstanceMap<DOMService<?, ?>> services = MutableClassToInstanceMap.create();
        private final YangInstanceIdentifier path;
        private SimpleDOMMountPoint mountPoint;

        DOMMountPointBuilderImpl(YangInstanceIdentifier path) {
            this.path = Objects.requireNonNull(path);
        }

        public <T extends DOMService<T, E>, E extends DOMService.Extension<T, E>> DOMMountPointService.DOMMountPointBuilder addService(Class<T> type, T impl) {
            this.services.putInstance(type, Objects.requireNonNull(impl));
            return this;
        }

        public ObjectRegistration<DOMMountPoint> register() {
            if (this.mountPoint != null) {
                throw new IllegalStateException("Mount point is already built");
            }
            this.mountPoint = SimpleDOMMountPoint.create((YangInstanceIdentifier)this.path, this.services);
            return DOMMountPointServiceImpl.this.registerMountPoint(this.mountPoint);
        }
    }
}

