/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.dom.api.DOMOperationImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.GlobalDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.RoutedDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.UnknownDOMRpcRoutingTableEntry;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

abstract sealed class DOMRpcRoutingTableEntry
extends AbstractDOMRoutingTableEntry<YangInstanceIdentifier, DOMRpcImplementation, DOMRpcAvailabilityListener, QName>
permits GlobalDOMRpcRoutingTableEntry, RoutedDOMRpcRoutingTableEntry, UnknownDOMRpcRoutingTableEntry {
    private final DOMRpcIdentifier rpcId;

    DOMRpcRoutingTableEntry(DOMRpcIdentifier rpcId, Map<YangInstanceIdentifier, List<DOMRpcImplementation>> implementations) {
        super(rpcId.getType(), implementations);
        this.rpcId = Objects.requireNonNull(rpcId);
    }

    final DOMRpcIdentifier getRpcId() {
        return this.rpcId;
    }

    final boolean containsContext(YangInstanceIdentifier contextReference) {
        return this.getImplementations().containsKey(contextReference);
    }

    @Override
    protected final Set<YangInstanceIdentifier> registeredIdentifiers(DOMRpcAvailabilityListener listener) {
        return Maps.filterValues(this.getImplementations(), list -> list.stream().anyMatch(arg_0 -> ((DOMRpcAvailabilityListener)listener).acceptsImplementation(arg_0))).keySet();
    }

    @Override
    protected Comparator<DOMRpcImplementation> implComparator() {
        return Comparator.comparingLong(DOMOperationImplementation::invocationCost);
    }
}

