/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionNotAvailableException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DefaultDOMRpcException;
import org.opendaylight.mdsal.dom.broker.DOMActionRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.DOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.GlobalDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.RoutedDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.UnknownDOMRpcRoutingTableEntry;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OperationInvocation {
    private static final Logger LOG = LoggerFactory.getLogger(OperationInvocation.class);

    private OperationInvocation() {
    }

    static ListenableFuture<? extends DOMRpcResult> invoke(DOMActionRoutingTableEntry entry, SchemaNodeIdentifier.Absolute type, DOMDataTreeIdentifier path, ContainerNode input) {
        List impls = entry.getImplementations(path);
        if (impls == null && (impls = entry.getImplementations(DOMDataTreeIdentifier.of((LogicalDatastoreType)path.datastore(), (YangInstanceIdentifier)YangInstanceIdentifier.of()))) == null) {
            return Futures.immediateFailedFuture((Throwable)new DOMActionNotAvailableException("No implementation of Action %s available for %s", new Object[]{type, path}));
        }
        return OperationInvocation.invokeAction((DOMActionImplementation)impls.getFirst(), type, path, input);
    }

    static ListenableFuture<? extends DOMRpcResult> invoke(DOMRpcRoutingTableEntry entry, ContainerNode input) {
        DOMRpcRoutingTableEntry dOMRpcRoutingTableEntry = entry;
        Objects.requireNonNull(dOMRpcRoutingTableEntry);
        DOMRpcRoutingTableEntry dOMRpcRoutingTableEntry2 = dOMRpcRoutingTableEntry;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GlobalDOMRpcRoutingTableEntry.class, RoutedDOMRpcRoutingTableEntry.class, UnknownDOMRpcRoutingTableEntry.class}, (Object)dOMRpcRoutingTableEntry2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                GlobalDOMRpcRoutingTableEntry global = (GlobalDOMRpcRoutingTableEntry)dOMRpcRoutingTableEntry2;
                yield OperationInvocation.invokeGlobalRpc(global, input);
            }
            case 1 -> {
                RoutedDOMRpcRoutingTableEntry routed = (RoutedDOMRpcRoutingTableEntry)dOMRpcRoutingTableEntry2;
                yield OperationInvocation.invokeRoutedRpc(routed, input);
            }
            case 2 -> {
                UnknownDOMRpcRoutingTableEntry unknown = (UnknownDOMRpcRoutingTableEntry)dOMRpcRoutingTableEntry2;
                yield Futures.immediateFailedFuture((Throwable)new DOMRpcImplementationNotAvailableException("%s is not resolved to an RPC", new Object[]{entry.getType()}));
            }
        };
    }

    private static ListenableFuture<? extends DOMRpcResult> invokeGlobalRpc(GlobalDOMRpcRoutingTableEntry entry, ContainerNode input) {
        return OperationInvocation.invokeRpc((DOMRpcImplementation)entry.getImplementations(YangInstanceIdentifier.of()).getFirst(), entry.getRpcId(), input);
    }

    private static ListenableFuture<? extends DOMRpcResult> invokeRoutedRpc(RoutedDOMRpcRoutingTableEntry entry, ContainerNode input) {
        List impls;
        Optional maybeKey = NormalizedNodes.findNode((NormalizedNode)input, (YangInstanceIdentifier)entry.getRpcId().getContextReference());
        if (maybeKey.isPresent()) {
            NormalizedNode key = (NormalizedNode)maybeKey.orElseThrow();
            Object value = key.body();
            if (value instanceof YangInstanceIdentifier) {
                YangInstanceIdentifier iid = (YangInstanceIdentifier)value;
                List specificImpls = entry.getImplementations(iid);
                if (specificImpls != null) {
                    return OperationInvocation.invokeRpc((DOMRpcImplementation)specificImpls.getFirst(), DOMRpcIdentifier.create((QName)((QName)entry.getType()), (YangInstanceIdentifier)iid), input);
                }
                LOG.debug("No implementation for context {} found will now look for wildcard id", (Object)iid);
                List mayBeRemoteImpls = entry.getImplementations(YangInstanceIdentifier.of());
                if (mayBeRemoteImpls != null) {
                    return OperationInvocation.invokeRpc((DOMRpcImplementation)mayBeRemoteImpls.getFirst(), DOMRpcIdentifier.create((QName)((QName)entry.getType()), (YangInstanceIdentifier)iid), input);
                }
            } else {
                LOG.warn("Ignoring wrong context value {}", value);
            }
        }
        if ((impls = entry.getImplementations(null)) != null) {
            return OperationInvocation.invokeRpc((DOMRpcImplementation)impls.getFirst(), entry.getRpcId(), input);
        }
        return Futures.immediateFailedFuture((Throwable)new DOMRpcImplementationNotAvailableException("No implementation of RPC %s available", new Object[]{entry.getType()}));
    }

    private static ListenableFuture<? extends DOMRpcResult> invokeAction(DOMActionImplementation impl, SchemaNodeIdentifier.Absolute type, DOMDataTreeIdentifier path, ContainerNode input) {
        try {
            return impl.invokeAction(type, path, input);
        }
        catch (Exception e) {
            LOG.debug("{} failed on {} with {}", new Object[]{impl, path, input.prettyTree(), e});
            return Futures.immediateFailedFuture((Throwable)new DefaultDOMRpcException("Action implementation failed: " + String.valueOf(e), (Throwable)e));
        }
    }

    private static ListenableFuture<? extends DOMRpcResult> invokeRpc(DOMRpcImplementation impl, DOMRpcIdentifier rpc, ContainerNode input) {
        try {
            return impl.invokeRpc(rpc, input);
        }
        catch (Exception e) {
            LOG.debug("{} failed on {} with {}", new Object[]{impl, rpc, input.prettyTree(), e});
            return Futures.immediateFailedFuture((Throwable)new DefaultDOMRpcException("RPC implementation failed: " + String.valueOf(e), (Throwable)e));
        }
    }
}

