/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.listener;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.CarPeople;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people.CarPerson;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people.CarPersonBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people.CarPersonKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.CarBought;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={})
public final class CarBoughtListener
implements NotificationService.Listener<CarBought> {
    private static final Logger LOG = LoggerFactory.getLogger(CarBoughtListener.class);
    private final DataBroker dataProvider;
    private final Registration reg;

    @Inject
    @Activate
    public CarBoughtListener(@Reference DataBroker dataProvider, @Reference NotificationService notifService) {
        this.dataProvider = Objects.requireNonNull(dataProvider);
        this.reg = notifService.registerListener(CarBought.class, (NotificationService.Listener)this);
    }

    @PreDestroy
    @Deactivate
    public void close() {
        this.reg.close();
    }

    public void onNotification(CarBought notification) {
        final CarPerson carPerson = new CarPersonBuilder().withKey(new CarPersonKey(notification.getCarId(), notification.getPersonId())).build();
        LOG.info("Car bought, adding car-person entry: [{}]", (Object)carPerson);
        KeyedInstanceIdentifier carPersonIId = InstanceIdentifier.builder(CarPeople.class).child(CarPerson.class, (Key)carPerson.key()).build();
        WriteTransaction tx = this.dataProvider.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)carPersonIId, (DataObject)carPerson);
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("Successfully added car-person entry: [{}]", (Object)carPerson);
            }

            public void onFailure(Throwable ex) {
                LOG.error("Failed to add car-person entry: [{}]", (Object)carPerson, (Object)ex);
            }
        }, MoreExecutors.directExecutor());
    }
}

