/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.BuyCar;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.BuyCarOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.CarBought;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.CarBoughtBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.AddPerson;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.AddPersonInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.AddPersonOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.AddPersonOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.People;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.Person;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.people.PersonBuilder;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.Notification;
import org.opendaylight.yangtools.binding.Rpc;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={})
public final class AddPersonImpl
implements AddPerson,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AddPersonImpl.class);
    private final Set<Registration> regs = new HashSet<Registration>();
    private final RpcProviderService rpcProviderService;
    private final DataBroker dataProvider;
    private final BuyCar buyCarRpc;

    @Inject
    @Activate
    public AddPersonImpl(@Reference DataBroker dataProvider, @Reference NotificationPublishService notificationProvider, @Reference RpcProviderService rpcProviderService) {
        this.dataProvider = Objects.requireNonNull(dataProvider);
        this.rpcProviderService = Objects.requireNonNull(rpcProviderService);
        Objects.requireNonNull(notificationProvider);
        this.buyCarRpc = input -> {
            LOG.info("Routed RPC buyCar : generating notification for buying car [{}]", (Object)input);
            CarBought carBought = new CarBoughtBuilder().setCarId(input.getCarId()).setPersonId(input.getPersonId()).build();
            return Futures.transform((ListenableFuture)notificationProvider.offerNotification((Notification)carBought), result -> RpcResultBuilder.success((Object)new BuyCarOutputBuilder().build()).build(), (Executor)MoreExecutors.directExecutor());
        };
        this.regs.add(rpcProviderService.registerRpcImplementation((Rpc)this.buyCarRpc));
        this.regs.add(rpcProviderService.registerRpcImplementation((Rpc)this));
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        this.regs.forEach(Registration::close);
        this.regs.clear();
    }

    public ListenableFuture<RpcResult<AddPersonOutput>> invoke(AddPersonInput input) {
        LOG.info("RPC addPerson : adding person [{}]", (Object)input);
        PersonBuilder builder = new PersonBuilder((Person)input);
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.people.Person person = builder.build();
        final SettableFuture futureResult = SettableFuture.create();
        final DataObjectIdentifier.WithKey personId = InstanceIdentifier.builder(People.class).child(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.people.Person.class, (Key)person.key()).build().toIdentifier();
        WriteTransaction tx = this.dataProvider.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.CONFIGURATION, (DataObjectIdentifier)personId, (DataObject)person);
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("RPC addPerson : person added successfully [{}]", (Object)person);
                AddPersonImpl.this.regs.add(AddPersonImpl.this.rpcProviderService.registerRpcImplementation((Rpc)AddPersonImpl.this.buyCarRpc, (Set)ImmutableSet.of((Object)personId)));
                LOG.info("RPC addPerson : routed rpc registered for instance ID [{}]", (Object)personId);
                futureResult.set((Object)RpcResultBuilder.success((Object)new AddPersonOutputBuilder().build()).build());
            }

            public void onFailure(Throwable ex) {
                LOG.error("RPC addPerson : person addition failed [{}]", (Object)person, (Object)ex);
                futureResult.set((Object)RpcResultBuilder.failed().withError(ErrorType.APPLICATION, ex.getMessage()).build());
            }
        }, MoreExecutors.directExecutor());
        return futureResult;
    }
}

