/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.spi.store.DOMStore;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTreeChangePublisher;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.SnapshotBackedTransactions;
import org.opendaylight.mdsal.dom.spi.store.SnapshotBackedWriteTransaction;
import org.opendaylight.mdsal.dom.store.inmemory.DOMStoreTransactionChainImpl;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.ExecutorServiceUtil;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTree;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.impl.di.InMemoryDataTreeFactory;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDOMDataStore
extends SnapshotBackedWriteTransaction.TransactionReadyPrototype<String>
implements DOMStore,
Identifiable<String>,
AutoCloseable,
DOMStoreTreeChangePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMDataStore.class);
    private final AtomicLong txCounter = new AtomicLong(0L);
    private final DataTree dataTree;
    private final InMemoryDOMStoreTreeChangePublisher changePublisher;
    private final ExecutorService dataChangeListenerExecutor;
    private final boolean debugTransactions;
    private final @NonNull String name;
    private volatile AutoCloseable closeable;

    public InMemoryDOMDataStore(String name, ExecutorService dataChangeListenerExecutor) {
        this(name, dataChangeListenerExecutor, 1000, false);
    }

    public InMemoryDOMDataStore(String name, ExecutorService dataChangeListenerExecutor, int maxDataChangeListenerQueueSize, boolean debugTransactions) {
        this(name, LogicalDatastoreType.OPERATIONAL, dataChangeListenerExecutor, maxDataChangeListenerQueueSize, debugTransactions);
    }

    public InMemoryDOMDataStore(String name, LogicalDatastoreType type, ExecutorService dataChangeListenerExecutor, int maxDataChangeListenerQueueSize, boolean debugTransactions) {
        this(name, InMemoryDOMDataStore.defaultConfig(type), dataChangeListenerExecutor, maxDataChangeListenerQueueSize, debugTransactions);
    }

    public InMemoryDOMDataStore(String name, DataTreeConfiguration config, ExecutorService dataChangeListenerExecutor, int maxDataChangeListenerQueueSize, boolean debugTransactions) {
        this.name = Objects.requireNonNull(name);
        this.dataChangeListenerExecutor = Objects.requireNonNull(dataChangeListenerExecutor);
        this.debugTransactions = debugTransactions;
        this.dataTree = new InMemoryDataTreeFactory().create(config);
        this.changePublisher = new InMemoryDOMStoreTreeChangePublisher("name", this.dataChangeListenerExecutor, maxDataChangeListenerQueueSize);
    }

    public void setCloseable(AutoCloseable closeable) {
        this.closeable = closeable;
    }

    public final String getIdentifier() {
        return this.name;
    }

    public final synchronized void onModelContextUpdated(EffectiveModelContext newModelContext) {
        this.dataTree.setEffectiveModelContext(newModelContext);
    }

    public DOMStoreReadTransaction newReadOnlyTransaction() {
        return SnapshotBackedTransactions.newReadTransaction((Object)this.nextIdentifier(), (boolean)this.debugTransactions, (DataTreeSnapshot)this.dataTree.takeSnapshot());
    }

    public DOMStoreReadWriteTransaction newReadWriteTransaction() {
        return SnapshotBackedTransactions.newReadWriteTransaction((Object)this.nextIdentifier(), (boolean)this.debugTransactions, (DataTreeSnapshot)this.dataTree.takeSnapshot(), (SnapshotBackedWriteTransaction.TransactionReadyPrototype)this);
    }

    public DOMStoreWriteTransaction newWriteOnlyTransaction() {
        return SnapshotBackedTransactions.newWriteTransaction((Object)this.nextIdentifier(), (boolean)this.debugTransactions, (DataTreeSnapshot)this.dataTree.takeSnapshot(), (SnapshotBackedWriteTransaction.TransactionReadyPrototype)this);
    }

    public DOMStoreTransactionChain createTransactionChain() {
        return new DOMStoreTransactionChainImpl(this);
    }

    @Override
    public void close() {
        ExecutorServiceUtil.tryGracefulShutdown((ExecutorService)this.dataChangeListenerExecutor, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (Exception e) {
                LOG.debug("Error closing instance", (Throwable)e);
            }
        }
    }

    public final boolean getDebugTransactions() {
        return this.debugTransactions;
    }

    final DataTreeSnapshot takeSnapshot() {
        return this.dataTree.takeSnapshot();
    }

    public synchronized Registration registerTreeChangeListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener) {
        return this.changePublisher.registerTreeChangeListener(treeId, listener, this.dataTree.takeSnapshot());
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    public Registration registerLegacyTreeChangeListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener) {
        return this.registerTreeChangeListener(treeId, listener);
    }

    protected void transactionAborted(SnapshotBackedWriteTransaction<String> tx) {
        LOG.debug("Tx: {} is closed.", tx.getIdentifier());
    }

    protected DOMStoreThreePhaseCommitCohort transactionReady(SnapshotBackedWriteTransaction<String> tx, DataTreeModification modification, Exception readyError) {
        LOG.debug("Tx: {} is submitted. Modifications: {}", tx.getIdentifier(), (Object)modification);
        return new InMemoryDOMStoreThreePhaseCommitCohort(this, tx, modification, readyError);
    }

    String nextIdentifier() {
        return this.name + "-" + this.txCounter.getAndIncrement();
    }

    void validate(DataTreeModification modification) throws DataValidationFailedException {
        this.dataTree.validate(modification);
    }

    DataTreeCandidate prepare(DataTreeModification modification) throws DataValidationFailedException {
        return this.dataTree.prepare(modification);
    }

    synchronized void commit(DataTreeCandidate candidate) {
        this.dataTree.commit(candidate);
        this.changePublisher.publishChange(candidate);
    }

    private static DataTreeConfiguration defaultConfig(LogicalDatastoreType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case LogicalDatastoreType.CONFIGURATION -> DataTreeConfiguration.DEFAULT_CONFIGURATION;
            case LogicalDatastoreType.OPERATIONAL -> DataTreeConfiguration.DEFAULT_OPERATIONAL;
        };
    }
}

