/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.OptimisticLockFailedException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.spi.store.AbstractDOMStoreTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.SnapshotBackedWriteTransaction;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataStore;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.tree.api.ConflictingModificationAppliedException;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InMemoryDOMStoreThreePhaseCommitCohort
implements DOMStoreThreePhaseCommitCohort {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMStoreThreePhaseCommitCohort.class);
    private static final ListenableFuture<Boolean> CAN_COMMIT_FUTURE = Futures.immediateFuture((Object)Boolean.TRUE);
    private final SnapshotBackedWriteTransaction<String> transaction;
    private final DataTreeModification modification;
    private final InMemoryDOMDataStore store;
    private final Exception operationError;
    @VisibleForTesting
    DataTreeCandidate candidate;

    InMemoryDOMStoreThreePhaseCommitCohort(InMemoryDOMDataStore store, SnapshotBackedWriteTransaction<String> transaction, DataTreeModification modification, Exception operationError) {
        this.transaction = Objects.requireNonNull(transaction);
        this.modification = Objects.requireNonNull(modification);
        this.store = Objects.requireNonNull(store);
        this.operationError = operationError;
    }

    private static void warnDebugContext(AbstractDOMStoreTransaction<?> transaction) {
        Throwable ctx = transaction.getDebugContext();
        if (ctx != null) {
            LOG.warn("Transaction {} has been allocated in the following context", transaction.getIdentifier(), (Object)ctx);
        }
    }

    public final ListenableFuture<Boolean> canCommit() {
        if (this.operationError != null) {
            return Futures.immediateFailedFuture((Throwable)this.operationError);
        }
        try {
            this.store.validate(this.modification);
            LOG.debug("Store Transaction: {} can be committed", this.getTransaction().getIdentifier());
            return CAN_COMMIT_FUTURE;
        }
        catch (ConflictingModificationAppliedException e) {
            LOG.warn("Store Tx: {} Conflicting modification for {}.", this.getTransaction().getIdentifier(), (Object)e.getPath());
            InMemoryDOMStoreThreePhaseCommitCohort.warnDebugContext(this.getTransaction());
            return Futures.immediateFailedFuture((Throwable)new OptimisticLockFailedException("Optimistic lock failed.", (Throwable)e));
        }
        catch (DataValidationFailedException e) {
            LOG.warn("Store Tx: {} Data Precondition failed for {}.", new Object[]{this.getTransaction().getIdentifier(), e.getPath(), e});
            InMemoryDOMStoreThreePhaseCommitCohort.warnDebugContext(this.getTransaction());
            LOG.trace("Store Tx: {} modifications: {} tree: {}", new Object[]{this.getTransaction().getIdentifier(), this.modification, this.store});
            return Futures.immediateFailedFuture((Throwable)new TransactionCommitFailedException("Data did not pass validation.", (Throwable)e, new RpcError[0]));
        }
        catch (Exception e) {
            LOG.warn("Unexpected failure in validation phase", (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public final ListenableFuture<Empty> preCommit() {
        try {
            this.candidate = this.store.prepare(this.modification);
            return Empty.immediateFuture();
        }
        catch (Exception e) {
            LOG.warn("Unexpected failure in pre-commit phase", (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public final ListenableFuture<Empty> abort() {
        this.candidate = null;
        return Empty.immediateFuture();
    }

    protected final SnapshotBackedWriteTransaction<String> getTransaction() {
        return this.transaction;
    }

    public ListenableFuture<CommitInfo> commit() {
        Preconditions.checkState((this.candidate != null ? 1 : 0) != 0, (Object)"Proposed subtree must be computed");
        this.store.commit(this.candidate);
        return CommitInfo.emptyFluentFuture();
    }
}

