/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.meta;

import com.google.common.annotations.Beta;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.ModelStatement;

public interface DeclaredStatement<A>
extends ModelStatement<A> {
    public @Nullable String rawArgument();

    public @NonNull List<? extends DeclaredStatement<?>> declaredSubstatements();

    default public <T extends DeclaredStatement<?>> @NonNull Collection<? extends T> declaredSubstatements(Class<T> type) {
        Objects.requireNonNull(type);
        return Collections2.transform((Collection)Collections2.filter(this.declaredSubstatements(), type::isInstance), type::cast);
    }

    @Beta
    default public @NonNull Optional<DeclarationReference> declarationReference() {
        return Optional.empty();
    }

    @Beta
    default public <T extends DeclaredStatement<?>> @NonNull Optional<T> findFirstDeclaredSubstatement(@NonNull Class<T> type) {
        Objects.requireNonNull(type);
        return this.streamDeclaredSubstatements(type).filter(type::isInstance).findFirst().map(type::cast);
    }

    @Beta
    default public <V, T extends DeclaredStatement<V>> @NonNull Optional<V> findFirstDeclaredSubstatementArgument(@NonNull Class<T> type) {
        return this.findFirstDeclaredSubstatement(type).map(ModelStatement::argument);
    }

    @Beta
    default public <T extends DeclaredStatement<?>> @NonNull Stream<T> streamDeclaredSubstatements(@NonNull Class<T> type) {
        Objects.requireNonNull(type);
        return this.declaredSubstatements().stream().filter(type::isInstance).map(type::cast);
    }
}

