/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;

public abstract sealed class SchemaNodeIdentifier
implements Immutable {
    private final @NonNull Object pathObj;
    private volatile int hash;

    private SchemaNodeIdentifier(QName qname) {
        this.pathObj = Objects.requireNonNull(qname);
    }

    private SchemaNodeIdentifier(ImmutableList<QName> qnames) {
        if (qnames.isEmpty()) {
            throw new IllegalArgumentException("SchemaNodeIdentifier has to have at least one node identifier");
        }
        this.pathObj = qnames;
    }

    public final @NonNull List<QName> getNodeIdentifiers() {
        ImmutableList immutableList;
        Object object = this.pathObj;
        if (object instanceof QName) {
            QName qname = (QName)object;
            immutableList = ImmutableList.of((Object)qname);
        } else {
            immutableList = this.coerceList();
        }
        return immutableList;
    }

    public final @NonNull QName firstNodeIdentifier() {
        QName qname;
        Object object = this.pathObj;
        return object instanceof QName ? (qname = (QName)object) : (QName)this.coerceList().getFirst();
    }

    public final @NonNull QName lastNodeIdentifier() {
        QName qname;
        Object object = this.pathObj;
        return object instanceof QName ? (qname = (QName)object) : (QName)this.coerceList().getLast();
    }

    public final int hashCode() {
        int local = this.hash;
        return local != 0 ? local : (this.hash = this.pathObj.hashCode());
    }

    public final boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.pathObj.equals(((SchemaNodeIdentifier)obj).pathObj);
    }

    public final String toString() {
        ImmutableList immutableList;
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        Object object = this.pathObj;
        if (object instanceof QName) {
            QName qname = (QName)object;
            immutableList = ImmutableList.of((Object)qname);
        } else {
            immutableList = this.simpleQNames();
        }
        return toStringHelper.add("qnames", immutableList).toString();
    }

    private List<?> simpleQNames() {
        ImmutableList<QName> qnames = this.coerceList();
        ArrayList<QName> ret = new ArrayList<QName>(qnames.size());
        QNameModule prev = null;
        for (QName qname : qnames) {
            QNameModule module = qname.getModule();
            ret.add((QName)(module.equals(prev) ? qname.getLocalName() : qname));
            prev = module;
        }
        return ret;
    }

    private ImmutableList<QName> coerceList() {
        return (ImmutableList)this.pathObj;
    }

    public static final class Descendant
    extends SchemaNodeIdentifier {
        private Descendant(ImmutableList<QName> qnames) {
            super(qnames);
        }

        private Descendant(QName qname) {
            super(qname);
        }

        public static @NonNull Descendant of(QName nodeIdentifier) {
            return new Descendant(nodeIdentifier);
        }

        public static @NonNull Descendant of(QName ... nodeIdentifiers) {
            return Descendant.of((Collection<QName>)ImmutableList.copyOf((Object[])nodeIdentifiers));
        }

        public static @NonNull Descendant of(Collection<QName> nodeIdentifiers) {
            ImmutableList qnames = ImmutableList.copyOf(nodeIdentifiers);
            return qnames.size() == 1 ? Descendant.of((QName)qnames.getFirst()) : new Descendant((ImmutableList<QName>)qnames);
        }
    }

    public static final class Absolute
    extends SchemaNodeIdentifier {
        private static final Interner<@NonNull Absolute> INTERNER = Interners.newWeakInterner();

        private Absolute(ImmutableList<QName> qnames) {
            super(qnames);
        }

        private Absolute(QName qname) {
            super(qname);
        }

        public static @NonNull Absolute of(QName nodeIdentifier) {
            return new Absolute(nodeIdentifier);
        }

        public static @NonNull Absolute of(QName ... nodeIdentifiers) {
            return Absolute.of((Collection<QName>)ImmutableList.copyOf((Object[])nodeIdentifiers));
        }

        public static @NonNull Absolute of(Collection<QName> nodeIdentifiers) {
            ImmutableList qnames = ImmutableList.copyOf(nodeIdentifiers);
            return qnames.size() == 1 ? Absolute.of((QName)qnames.getFirst()) : new Absolute((ImmutableList<QName>)qnames);
        }

        public @NonNull Absolute intern() {
            return (Absolute)INTERNER.intern((Object)this);
        }
    }
}

