/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMetadata;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ForwardingNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;

final class NormalizedNodeStreamWriterMetadataDecorator
extends ForwardingNormalizedNodeStreamWriter {
    private final Deque<NormalizedMetadata> stack = new ArrayDeque<NormalizedMetadata>();
    private final NormalizedNodeStreamWriter writer;
    private final NormalizedNodeStreamWriter.MetadataExtension metaWriter;
    private final NormalizedMetadata metadata;
    private int absentDepth = 0;

    NormalizedNodeStreamWriterMetadataDecorator(NormalizedNodeStreamWriter writer, NormalizedNodeStreamWriter.MetadataExtension metaWriter, NormalizedMetadata metadata) {
        this.writer = Objects.requireNonNull(writer);
        this.metaWriter = Objects.requireNonNull(metaWriter);
        this.metadata = Objects.requireNonNull(metadata);
    }

    @Override
    protected NormalizedNodeStreamWriter delegate() {
        return this.writer;
    }

    @Override
    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        super.startLeafNode(name);
        this.enterMetadataNode(name);
    }

    @Override
    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startLeafSet(name, childSizeHint);
        this.enterMetadataNode(name);
    }

    @Override
    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startOrderedLeafSet(name, childSizeHint);
        this.enterMetadataNode(name);
    }

    @Override
    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        super.startLeafSetEntryNode(name);
        this.enterMetadataNode(name);
    }

    @Override
    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startContainerNode(name, childSizeHint);
        this.enterMetadataNode(name);
    }

    @Override
    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startUnkeyedList(name, childSizeHint);
        this.enterMetadataNode(name);
    }

    @Override
    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startUnkeyedListItem(name, childSizeHint);
        this.enterMetadataNode(name);
    }

    @Override
    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startMapNode(name, childSizeHint);
        this.enterMetadataNode(name);
    }

    @Override
    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        super.startMapEntryNode(identifier, childSizeHint);
        this.enterMetadataNode(identifier);
    }

    @Override
    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startOrderedMapNode(name, childSizeHint);
        this.enterMetadataNode(name);
    }

    @Override
    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startChoiceNode(name, childSizeHint);
        this.enterMetadataNode(name);
    }

    @Override
    public boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        boolean ret = super.startAnyxmlNode(name, objectModel);
        if (ret) {
            this.enterMetadataNode(name);
        }
        return ret;
    }

    @Override
    public void endNode() throws IOException {
        super.endNode();
        if (this.absentDepth > 0) {
            --this.absentDepth;
        } else {
            this.stack.pop();
        }
    }

    private void enterMetadataNode(YangInstanceIdentifier.PathArgument name) throws IOException {
        if (this.absentDepth > 0) {
            ++this.absentDepth;
            return;
        }
        NormalizedMetadata current = this.stack.peek();
        if (current != null) {
            NormalizedMetadata child = current.getChildren().get(name);
            if (child != null) {
                this.enterChild(child);
            } else {
                this.absentDepth = 1;
            }
        } else {
            this.enterChild(this.metadata);
        }
    }

    private void enterChild(NormalizedMetadata child) throws IOException {
        Map<QName, Object> annotations = child.getAnnotations();
        if (!annotations.isEmpty()) {
            this.metaWriter.metadata((ImmutableMap<QName, Object>)ImmutableMap.copyOf(annotations));
        }
        this.stack.push(child);
    }
}

