/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.util;

import com.google.common.util.concurrent.FluentFuture;
import org.opendaylight.mdsal.binding.api.QueryOperations;
import org.opendaylight.mdsal.binding.api.Transaction;
import org.opendaylight.mdsal.binding.api.query.QueryExpression;
import org.opendaylight.mdsal.binding.api.query.QueryResult;
import org.opendaylight.mdsal.binding.spi.ForwardingTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.datastores.rev180214.Datastore;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.datastores.rev180214.Operational;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.datastores.rev180214.Running;
import org.opendaylight.yangtools.binding.DataObject;

abstract class TypedTransaction<D extends Datastore, X extends Transaction>
extends ForwardingTransaction {
    private final LogicalDatastoreType datastoreType;
    private final X delegate;

    TypedTransaction(D datastore, X delegate) {
        this.datastoreType = TypedTransaction.typeOf(datastore);
        this.delegate = delegate;
    }

    static final LogicalDatastoreType typeOf(Datastore datastore) {
        if (datastore.equals((Object)Running.VALUE)) {
            return LogicalDatastoreType.CONFIGURATION;
        }
        if (datastore.equals((Object)Operational.VALUE)) {
            return LogicalDatastoreType.OPERATIONAL;
        }
        throw new IllegalArgumentException("Unsupported datastore " + String.valueOf(datastore));
    }

    protected final X delegate() {
        return this.delegate;
    }

    final LogicalDatastoreType getDatastoreType() {
        return this.datastoreType;
    }

    final <T extends DataObject> FluentFuture<QueryResult<T>> doExecute(QueryExpression<T> query) {
        X x = this.delegate;
        if (x instanceof QueryOperations) {
            QueryOperations queryOps = (QueryOperations)x;
            return queryOps.execute(this.datastoreType, query);
        }
        throw new UnsupportedOperationException("Query execution requires backend support");
    }
}

