/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.eos.common.api;

import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.HierarchicalIdentifier;
import org.opendaylight.yangtools.concepts.Identifiable;

public class GenericEntity<T extends HierarchicalIdentifier<T>>
implements Serializable,
Identifiable<T> {
    private static final long serialVersionUID = 1L;
    private final @NonNull String type;
    private final @NonNull T id;

    protected GenericEntity(@NonNull String type, @NonNull T id) {
        this.type = Objects.requireNonNull(type, "type should not be null");
        this.id = (HierarchicalIdentifier)Objects.requireNonNull(id, "id should not be null");
    }

    public final T getIdentifier() {
        return this.id;
    }

    public final @NonNull String getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GenericEntity entity = (GenericEntity)obj;
        return this.id.equals(entity.id) && this.type.equals(entity.type);
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.id.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [type=" + this.type + ", id=" + String.valueOf(this.id) + "]";
    }
}

