/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MandatoryEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractSchemaTreeStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.ImplicitParentAwareStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.QNameWithFlagsEffectiveStatementState;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class ChoiceStatementSupport
extends AbstractSchemaTreeStatementSupport<ChoiceStatement, ChoiceEffectiveStatement>
implements ImplicitParentAwareStatementSupport {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.CHOICE).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.CASE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();
    private static final ImmutableSet<StatementDefinition> RFC6020_CASE_SHORTHANDS = ImmutableSet.of((Object)YangStmtMapping.ANYXML, (Object)YangStmtMapping.CONTAINER, (Object)YangStmtMapping.LEAF, (Object)YangStmtMapping.LIST, (Object)YangStmtMapping.LEAF_LIST);
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.CHOICE).addAny((StatementDefinition)YangStmtMapping.ANYDATA).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.CASE).addAny((StatementDefinition)YangStmtMapping.CHOICE).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DEFAULT).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addOptional((StatementDefinition)YangStmtMapping.MANDATORY).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.WHEN).build();
    private static final ImmutableSet<StatementDefinition> RFC7950_CASE_SHORTHANDS = ImmutableSet.of((Object)YangStmtMapping.ANYDATA, (Object)YangStmtMapping.ANYXML, (Object)YangStmtMapping.CHOICE, (Object)YangStmtMapping.CONTAINER, (Object)YangStmtMapping.LEAF, (Object)YangStmtMapping.LIST, (Object[])new StatementDefinition[]{YangStmtMapping.LEAF_LIST});
    private final ImmutableSet<StatementDefinition> caseShorthands;

    private ChoiceStatementSupport(YangParserConfiguration config, SubstatementValidator validator, ImmutableSet<StatementDefinition> caseShorthands) {
        super((StatementDefinition)YangStmtMapping.CHOICE, ChoiceStatementSupport.instantiatedPolicy(), config, Objects.requireNonNull(validator));
        this.caseShorthands = Objects.requireNonNull(caseShorthands);
    }

    public static @NonNull ChoiceStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new ChoiceStatementSupport(config, RFC6020_VALIDATOR, RFC6020_CASE_SHORTHANDS);
    }

    public static @NonNull ChoiceStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new ChoiceStatementSupport(config, RFC7950_VALIDATOR, RFC7950_CASE_SHORTHANDS);
    }

    public Optional<StatementSupport<?, ?, ?>> getImplicitParentFor(NamespaceStmtCtx parent, StatementDefinition stmtDef) {
        if (!this.caseShorthands.contains((Object)stmtDef)) {
            return Optional.empty();
        }
        return Optional.of((StatementSupport)Verify.verifyNotNull((Object)((StatementSupport)parent.namespaceItem(StatementSupport.NAMESPACE, (Object)YangStmtMapping.CASE.getStatementName()))));
    }

    protected ChoiceStatement createDeclared(BoundStmtCtx<QName> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createChoice((QName)((QName)ctx.getArgument()), substatements);
    }

    protected ChoiceStatement attachDeclarationReference(ChoiceStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateChoice((ChoiceStatement)stmt, (DeclarationReference)reference);
    }

    public ChoiceEffectiveStatement copyEffective(EffectiveStmtCtx.Current<QName, ChoiceStatement> stmt, ChoiceEffectiveStatement original) {
        return EffectiveStatements.copyChoice((ChoiceEffectiveStatement)original, (QName)((QName)stmt.getArgument()), (int)ChoiceStatementSupport.computeFlags(stmt, original.effectiveSubstatements()));
    }

    protected ChoiceEffectiveStatement createEffective(EffectiveStmtCtx.Current<QName, ChoiceStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        CaseSchemaNode defaultCase;
        String defaultArg = (String)ChoiceStatementSupport.findFirstArgument(substatements, DefaultEffectiveStatement.class, null);
        if (defaultArg != null) {
            QName qname;
            try {
                qname = QName.create((QName)((QName)stmt.getArgument()), (String)defaultArg);
            }
            catch (IllegalArgumentException e) {
                throw new SourceException(stmt, (Throwable)e, "Default statement has invalid name '%s'", new Object[]{defaultArg});
            }
            defaultCase = (CaseSchemaNode)InferenceException.throwIfNull((Object)ChoiceStatementSupport.findCase(qname, substatements), stmt, (String)"Default statement refers to missing case %s", (Object[])new Object[]{qname});
        } else {
            defaultCase = null;
        }
        try {
            return EffectiveStatements.createChoice((ChoiceStatement)((ChoiceStatement)stmt.declared()), (QName)((QName)stmt.getArgument()), (int)ChoiceStatementSupport.computeFlags(stmt, substatements), substatements, defaultCase);
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    public EffectiveStatementState extractEffectiveState(ChoiceEffectiveStatement stmt) {
        Verify.verify((boolean)(stmt instanceof ChoiceSchemaNode), (String)"Unexpected statement %s", (Object)stmt);
        ChoiceSchemaNode schema = (ChoiceSchemaNode)stmt;
        return new QNameWithFlagsEffectiveStatementState((QName)stmt.argument(), new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)schema).setStatus(schema.getStatus()).setConfiguration((Boolean)schema.effectiveConfig().orElse(null)).setMandatory(schema.isMandatory()).toFlags());
    }

    private static int computeFlags(EffectiveStmtCtx.Current<?, ?> stmt, Collection<? extends EffectiveStatement<?, ?>> substatements) {
        return new EffectiveStatementMixins.EffectiveStatementWithFlags.FlagsBuilder().setHistory((CopyableNode)stmt.history()).setStatus((Status)ChoiceStatementSupport.findFirstArgument(substatements, StatusEffectiveStatement.class, (Object)Status.CURRENT)).setConfiguration(stmt.effectiveConfig().asNullable()).setMandatory(((Boolean)ChoiceStatementSupport.findFirstArgument(substatements, MandatoryEffectiveStatement.class, (Object)Boolean.FALSE)).booleanValue()).toFlags();
    }

    private static CaseSchemaNode findCase(QName qname, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        for (EffectiveStatement effectiveStatement : substatements) {
            CaseSchemaNode choiceCaseNode;
            if (!(effectiveStatement instanceof CaseSchemaNode) || !qname.equals((Object)(choiceCaseNode = (CaseSchemaNode)effectiveStatement).getQName())) continue;
            return choiceCaseNode;
        }
        return null;
    }
}

