/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.YangVersionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YangVersionStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class YangVersionStatementSupport
extends AbstractStatementSupport<YangVersion, YangVersionStatement, YangVersionEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.YANG_VERSION).build();

    public YangVersionStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.YANG_VERSION, StatementSupport.StatementPolicy.reject(), config, SUBSTATEMENT_VALIDATOR);
    }

    public YangVersion parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return (YangVersion)SourceException.throwIfNull((Object)YangVersion.forString((String)value), ctx, (String)"Unsupported YANG version %s", (Object[])new Object[]{value});
    }

    public void onPreLinkageDeclared(StmtContext.Mutable<YangVersion, YangVersionStatement, YangVersionEffectiveStatement> stmt) {
        stmt.setRootVersion((YangVersion)stmt.argument());
    }

    protected YangVersionStatement createDeclared(BoundStmtCtx<YangVersion> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createYangVersion((YangVersion)((YangVersion)ctx.getArgument()), substatements);
    }

    protected YangVersionStatement attachDeclarationReference(YangVersionStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateYangVersion((YangVersionStatement)stmt, (DeclarationReference)reference);
    }

    protected YangVersionEffectiveStatement createEffective(EffectiveStmtCtx.Current<YangVersion, YangVersionStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createYangVersion((YangVersionStatement)((YangVersionStatement)stmt.declared()), substatements);
    }
}

